/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.query;

import java.util.List;
import org.mule.common.query.DefaultQueryVisitor;
import org.mule.common.query.Field;
import org.mule.common.query.Type;
import org.mule.common.query.expression.Direction;
import org.mule.common.query.expression.OperatorVisitor;
import org.mule.common.query.expression.Value;
import org.mule.module.dynamicscrm.query.DynamicsCrmOperatorVisitor;
import org.mule.module.dynamicscrm.query.IDynamicsCrmQueryVisitor;
import org.mule.module.dynamicscrm.query.exception.DynamicsCrmQueryException;
import org.mule.module.dynamicscrm.query.where.DynamicsCrmWhereManager;

public class DynamicsCrmQueryVisitor
extends DefaultQueryVisitor
implements IDynamicsCrmQueryVisitor {
    private Type entity = null;
    private List<Field> fields = null;
    private DynamicsCrmWhereManager where = new DynamicsCrmWhereManager();
    private List<Field> orderBy = null;
    private Direction orderByDirection;

    @Override
    public String getQuery() {
        if (this.entity == null) {
            throw new DynamicsCrmQueryException("The entity for the query must be specified");
        }
        if (this.fields == null) {
            throw new DynamicsCrmQueryException("The fields of the entity for the query must be specified");
        }
        StringBuffer queryString = new StringBuffer();
        queryString.append("<fetch mapping=\"logical\"").append(">").append(String.format("<entity name=\"%s\">", this.entity.getName()));
        for (Field field : this.fields) {
            queryString.append(String.format("<attribute name=\"%s\" />", field.getName()));
        }
        queryString.append(this.where.getQueryXml());
        this.where.release();
        if (this.orderBy != null) {
            for (Field field : this.orderBy) {
                queryString.append(String.format("<order attribute=\"%s\" descending=\"%s\" />", field.getName(), this.orderByDirection.equals((Object)Direction.DESC) ? "true" : "false"));
            }
        }
        queryString.append("</entity>").append("</fetch>");
        return queryString.toString();
    }

    public void visitTypes(List<Type> types) {
        this.entity = types.get(0);
    }

    public void visitFields(List<Field> fields) {
        this.fields = fields;
    }

    public OperatorVisitor operatorVisitor() {
        return new DynamicsCrmOperatorVisitor();
    }

    public void visitAnd() {
        this.where.and();
    }

    public void visitBeginExpression() {
        this.where.beginExpression();
    }

    public void visitComparison(String operator, Field field, Value value) {
        this.where.comparison(operator, field.getName(), value.getValue().toString());
    }

    public void visitEndPrecedence() {
        this.where.endPrecedence();
    }

    public void visitInitPrecedence() {
        this.where.initPrecedence();
    }

    public void visitLimit(int limit) {
    }

    public void visitOR() {
        this.where.or();
    }

    public void visitOffset(int offset) {
    }

    public void visitOrderByFields(List<Field> orderByFields, Direction direction) {
        StringBuilder s = new StringBuilder();
        for (Field f : orderByFields) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(this.fieldToString(f));
        }
        this.orderBy = orderByFields;
        this.orderByDirection = direction;
    }

    private String fieldToString(Field f) {
        return String.format("{\"name\":\"%s\", \"type\":\"%s\"}", f.getName(), f.getType());
    }
}

