/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.query.where;

public class DynamicsCrmWhereLeaf implements DynamicsCrmWhereComponent {

	private String operator;
	private String field;
	private String value;
		
	public DynamicsCrmWhereLeaf(String operator, String field, String value) {
		super();
		this.operator = operator;
		this.field = field;
		this.value = value;
	}

	@Override
	public String getQueryXml() {
		return String.format("<condition attribute=\"%s\" operator=\"%s\" value=\"%s\" />", field, operator, value);
	}

	@Override
	public void release() {
		operator = null;
		field = null;
		value = null;
	}

}
