/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.module.dynamicscrm.utils;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfstringanyType;
import org.mule.api.MuleContext;

import com.microsoft.schemas._2003._10.serialization.Guid;
import com.microsoft.schemas.xrm._2011.contracts.Entity;
import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;

public class DynamicsCrmUtils {
	
	static public List<Map<String, Object>> mapEntityCollectionToMapCollection(EntityCollection entityCollection)
    {
        List<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : entityCollection.getEntities().getEntities())
        {
            entities.add(mapEntityToMap(entity));
        }
        return entities;
    }
	
	static public Map<String, Object> mapEntityToMap(Entity entity)
    {
        Map<String, Object> entityMap = new HashMap<String, Object>();
        for (KeyValuePairOfstringanyType attribute : entity.getAttributes().getKeyValuePairOfstringanyTypes())
        {
            Object value = attribute.getValue();

            if (value instanceof Guid)
            {
                value = ((Guid) value).getValue();
            }

            entityMap.put(attribute.getKey(), value);
        }
        return entityMap;
    }
	
	static public String replaceClasspathInStringForCurrentPath(String path, Class<?> clazz, MuleContext muleContext) throws FileNotFoundException {
		
		if (path == null || !path.contains("classpath:")) {
			return path;
		}
		
		path = path.replace("classpath:", "");
		URL resource = clazz.getClassLoader().getResource(path);
		if (resource != null) {
			return resource.getPath();
		} else {
			/*
			 * The Application ClassLoader of a Mule Application runs as a Child classLoader of the Plugin, so the getClass().getClassLoader()
			 * will not see the App classLoader.
			 * The only way to get it is asking for the MuleContext and requesting the execution ClassLoader
			 */
			ClassLoader executionClassLoader = muleContext != null ? muleContext.getExecutionClassLoader() : null;
			if (executionClassLoader != null) {
				resource = executionClassLoader.getResource(path);
				
				if (resource != null) {
					return resource.getPath();
				}
			}
		}
		
		throw new FileNotFoundException("Can not locate the file " + path);		
	}
}
