/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.dynamicscrm.utils;

import com.microsoft.schemas._2003._10.serialization.Guid;
import com.microsoft.schemas.xrm._2011.contracts.Entity;
import com.microsoft.schemas.xrm._2011.contracts.EntityCollection;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datacontract.schemas._2004._07.system_collections.KeyValuePairOfstringanyType;
import org.mule.api.MuleContext;

public class DynamicsCrmUtils {
    public static List<Map<String, Object>> mapEntityCollectionToMapCollection(EntityCollection entityCollection) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : entityCollection.getEntities().getEntities()) {
            entities.add(DynamicsCrmUtils.mapEntityToMap(entity));
        }
        return entities;
    }

    public static Map<String, Object> mapEntityToMap(Entity entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        for (KeyValuePairOfstringanyType attribute : entity.getAttributes().getKeyValuePairOfstringanyTypes()) {
            Object value = attribute.getValue();
            if (value instanceof Guid) {
                value = ((Guid)value).getValue();
            }
            entityMap.put(attribute.getKey(), value);
        }
        return entityMap;
    }

    public static String replaceClasspathInStringForCurrentPath(String path, Class<?> clazz, MuleContext muleContext) throws FileNotFoundException {
        ClassLoader executionClassLoader;
        if (path == null || !path.contains("classpath:")) {
            return path;
        }
        path = path.replace("classpath:", "");
        URL resource = clazz.getClassLoader().getResource(path);
        if (resource != null) {
            return resource.getPath();
        }
        ClassLoader classLoader = executionClassLoader = muleContext != null ? muleContext.getExecutionClassLoader() : null;
        if (executionClassLoader != null && (resource = executionClassLoader.getResource(path)) != null) {
            return resource.getPath();
        }
        throw new FileNotFoundException("Can not locate the file " + path);
    }
}

