/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api.oauth;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.quickbooks.api.ObjectStoreHelper;
import org.mule.modules.quickbooks.api.oauth.OAuthCredentials;
import org.mule.modules.quickbooks.api.oauth.QuickbooksOAuthClient;
import org.mule.util.UUID;

public class DefaultQuickbooksOAuthClient
implements QuickbooksOAuthClient {
    private static final Logger LOGGER = Logger.getLogger(DefaultQuickbooksOAuthClient.class);
    private String requestToken;
    private String requestTokenSecret;
    private String consumerKey;
    private String consumerSecret;
    private ObjectStoreHelper objectStoreHelper;

    public DefaultQuickbooksOAuthClient(String consumerKey, String consumerSecret, ObjectStore objectStoreRef) {
        Validate.notEmpty((String)consumerKey);
        Validate.notEmpty((String)consumerSecret);
        this.setConsumerKey(consumerKey);
        this.setConsumerSecret(consumerSecret);
        this.setObjectStoreHelper(new ObjectStoreHelper(objectStoreRef));
    }

    @Override
    public String authorize(String requestTokenUrl, String accessTokenUrl, String authorizationUrl, String callbackUrl, String requestTokenId, OAuthMessageSigner messageSigner) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException, ObjectStoreException {
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
        DefaultOAuthProvider provider = new DefaultOAuthProvider(requestTokenUrl, accessTokenUrl, authorizationUrl);
        provider.setOAuth10a(true);
        if (messageSigner != null) {
            consumer.setMessageSigner(messageSigner);
        } else {
            consumer.setMessageSigner((OAuthMessageSigner)new PlainTextMessageSigner());
        }
        this.setConsumerKey(this.consumerKey);
        this.setConsumerSecret(this.consumerSecret);
        if (StringUtils.isBlank((String)requestTokenId)) {
            requestTokenId = UUID.getUUID();
        }
        callbackUrl = callbackUrl.concat("?userId=" + requestTokenId);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageStringBuilder = new StringBuilder();
            messageStringBuilder.append("Retrieving OAuth requestToken ");
            messageStringBuilder.append("[consumerKey = ");
            messageStringBuilder.append(this.consumerKey);
            messageStringBuilder.append("] ");
            messageStringBuilder.append("[consumerSecret = ");
            messageStringBuilder.append(this.consumerSecret);
            messageStringBuilder.append("] ");
            messageStringBuilder.append("[callbackUrl = ");
            messageStringBuilder.append(callbackUrl);
            messageStringBuilder.append("] ");
            LOGGER.debug((Object)messageStringBuilder.toString());
        }
        String authTokenUrl = provider.retrieveRequestToken((OAuthConsumer)consumer, callbackUrl, new String[0]);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageStringBuilder = new StringBuilder();
            messageStringBuilder.append("Request Token INFO ");
            messageStringBuilder.append("[authTokenUrl = ");
            messageStringBuilder.append(authTokenUrl);
            messageStringBuilder.append("] ");
            messageStringBuilder.append("[requestToken = ");
            messageStringBuilder.append(consumer.getToken());
            messageStringBuilder.append("] ");
            messageStringBuilder.append("[requestTokenSecret = ");
            messageStringBuilder.append(consumer.getTokenSecret());
            messageStringBuilder.append("] ");
            LOGGER.debug((Object)messageStringBuilder.toString());
        }
        this.setRequestToken(consumer.getToken());
        this.setRequestTokenSecret(consumer.getTokenSecret());
        requestTokenId = this.removeSpecialCharacters(requestTokenId);
        this.getObjectStoreHelper().store(requestTokenId, new OAuthCredentials(consumer.getToken(), consumer.getTokenSecret(), requestTokenUrl, accessTokenUrl, authorizationUrl), true);
        LOGGER.debug((Object)("Request Token stored using ID: " + requestTokenId));
        return authTokenUrl;
    }

    @Override
    public OAuthCredentials getAccessToken(String verifier, String requestTokenId, OAuthMessageSigner messageSigner) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException, ObjectStoreException {
        requestTokenId = this.removeSpecialCharacters(requestTokenId);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageStringBuilder = new StringBuilder();
            messageStringBuilder.append("Trying to retrieve request token information ");
            messageStringBuilder.append("[requestTokenId = ");
            messageStringBuilder.append(requestTokenId);
            messageStringBuilder.append("] ");
            LOGGER.debug((Object)messageStringBuilder.toString());
        }
        OAuthCredentials credentials = (OAuthCredentials)this.getObjectStoreHelper().retrieve(requestTokenId);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageStringBuilder = new StringBuilder();
            messageStringBuilder.append("Retrieved request token INFO ");
            messageStringBuilder.append("[requestToken = ");
            messageStringBuilder.append(credentials.getAccessToken());
            messageStringBuilder.append("] ");
            messageStringBuilder.append("[requestTokenSecret = ");
            messageStringBuilder.append(credentials.getAccessTokenSecret());
            messageStringBuilder.append("] ");
            LOGGER.debug((Object)messageStringBuilder.toString());
        }
        DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.getConsumerKey(), this.getConsumerSecret());
        DefaultOAuthProvider provider = new DefaultOAuthProvider(credentials.getRequestTokenUrl(), credentials.getAccessTokenUrl(), credentials.getAuthUrl());
        provider.setOAuth10a(true);
        if (messageSigner != null) {
            consumer.setMessageSigner(messageSigner);
        } else {
            consumer.setMessageSigner((OAuthMessageSigner)new PlainTextMessageSigner());
        }
        consumer.setTokenWithSecret(credentials.getAccessToken(), credentials.getAccessTokenSecret());
        provider.retrieveAccessToken((OAuthConsumer)consumer, verifier, new String[0]);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder messageStringBuilder = new StringBuilder();
            messageStringBuilder.append("Token authenticated successfully: ");
            messageStringBuilder.append("[verifier = ");
            messageStringBuilder.append(verifier);
            messageStringBuilder.append("] ");
            LOGGER.debug((Object)messageStringBuilder.toString());
        }
        credentials.setAccessToken(consumer.getToken());
        credentials.setAccessTokenSecret(consumer.getTokenSecret());
        return credentials;
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public String getRequestTokenSecret() {
        return this.requestTokenSecret;
    }

    public void setRequestToken(String requestToken) {
        this.requestToken = requestToken;
    }

    public void setRequestTokenSecret(String requestTokenSecret) {
        this.requestTokenSecret = requestTokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public ObjectStoreHelper getObjectStoreHelper() {
        return this.objectStoreHelper;
    }

    public void setObjectStoreHelper(ObjectStoreHelper objectStoreHelper) {
        this.objectStoreHelper = objectStoreHelper;
    }

    private String removeSpecialCharacters(String idToStore) {
        return StringUtils.remove((String)idToStore, (String)"%");
    }
}

