/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api.openid;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.quickbooks.api.ObjectStoreHelper;
import org.mule.modules.quickbooks.api.openid.OpenIDClient;
import org.mule.modules.quickbooks.api.openid.OpenIDCredentials;
import org.mule.modules.quickbooks.api.openid.OpenIDManager;
import org.mule.modules.quickbooks.api.openid.OpenIdException;
import org.openid4java.OpenIDException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;

public class DefaultOpenIDClient
implements OpenIDClient {
    public static final Logger logger = Logger.getLogger(DefaultOpenIDClient.class);
    private ObjectStoreHelper objectStoreHelper;

    public DefaultOpenIDClient(ObjectStoreHelper objectStoreHelper) {
        this.setObjectStoreHelper(objectStoreHelper);
    }

    @Override
    public String initialize(String providerUrl, String returnUrl, boolean verifyResponse) throws ObjectStoreException {
        AuthRequest authReq;
        DiscoveryInformation discovered;
        ArrayList<DiscoveryInformation> discoveries = new ArrayList<DiscoveryInformation>();
        ConsumerManager manager = new ConsumerManager();
        manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        manager.setMinAssocSessEnc(AssociationSessionType.DH_SHA256);
        try {
            logger.info((Object)("OpenID Provider URL = " + providerUrl));
            discovered = new DiscoveryInformation(new URL(providerUrl));
        }
        catch (DiscoveryException e) {
            throw new OpenIdException(e);
        }
        catch (MalformedURLException me) {
            throw new OpenIdException(me);
        }
        discoveries.add(discovered);
        DiscoveryInformation discoveryInfo = manager.associate(discoveries);
        FetchRequest fetch = FetchRequest.createFetchRequest();
        try {
            fetch.addAttribute("FirstName", "http://axschema.org/namePerson/first", true);
            fetch.addAttribute("LastName", "http://axschema.org/namePerson/last", true);
            fetch.addAttribute("Email", "http://axschema.org/contact/email", true);
            fetch.addAttribute("RealmId", "http://axschema.org/intuit/realmId", true);
        }
        catch (MessageException e) {
            throw new OpenIdException(e);
        }
        fetch.setCount("Email", 3);
        logger.info((Object)("openIdReturnUrl = " + returnUrl));
        try {
            authReq = manager.authenticate(discoveryInfo, returnUrl);
            authReq.addExtension((MessageExtension)fetch);
        }
        catch (MessageException e) {
            throw new OpenIdException(e);
        }
        catch (ConsumerException e) {
            throw new OpenIdException(e);
        }
        logger.info((Object)("authReq.getDestinationUrl: " + authReq.getDestinationUrl(true)));
        if (verifyResponse) {
            logger.info((Object)("Storing OpenID manager information using key: " + authReq.getHandle()));
            this.getObjectStoreHelper().store(authReq.getHandle(), new OpenIDManager(manager, discoveryInfo), true);
        }
        return authReq.getDestinationUrl(true);
    }

    @Override
    public OpenIDCredentials verifyOpenIDFromIntuit(String receivingUrl, Map<String, String> params, boolean verifyResponse) throws MessageException, ObjectStoreException {
        OpenIDCredentials credentials = new OpenIDCredentials();
        if (verifyResponse) {
            Identifier identifier = this.verifyResponse(receivingUrl, params);
            logger.debug((Object)("OpenID identifier:" + (identifier == null ? "null" : identifier.getIdentifier())));
        }
        credentials.setIdentity(params.get("openid.identity"));
        credentials.setFirstName(params.get("openid.alias3.value.alias1"));
        credentials.setLastName(params.get("openid.alias3.value.alias2"));
        credentials.setEmail(params.get("openid.alias3.value.alias3"));
        credentials.setRealmId(params.get("openid.alias3.value.alias4"));
        logger.debug((Object)("openid.identity: " + credentials.getIdentity()));
        logger.debug((Object)("openid.alias3.value.alias1: " + credentials.getFirstName()));
        logger.debug((Object)("openid.alias3.value.alias2: " + credentials.getLastName()));
        logger.debug((Object)("openid.alias3.value.alias3: " + credentials.getEmail()));
        logger.debug((Object)("openid.alias3.value.alias4: " + credentials.getRealmId()));
        logger.info((Object)"VerifyOpenIDFromIntuit completed");
        return credentials;
    }

    public Identifier verifyResponse(String receivingUrl, Map<String, String> params) throws MessageException, ObjectStoreException {
        try {
            ParameterList response = new ParameterList(params);
            logger.debug((Object)("Retrieving OpenID manager information using key: " + params.get("openid.assoc_handle")));
            OpenIDManager openIdManager = (OpenIDManager)this.getObjectStoreHelper().retrieve(params.get("openid.assoc_handle"));
            logger.debug((Object)("ReceivingUrl: " + receivingUrl));
            DiscoveryInformation discovered = openIdManager.getDiscovery();
            ConsumerManager manager = openIdManager.getManager();
            VerificationResult verification = manager.verify(receivingUrl, response, discovered);
            Identifier verified = verification.getVerifiedId();
            if (verified != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    logger.debug((Object)fetchResp.getAttributeValue("FirstName"));
                    logger.debug((Object)fetchResp.getAttributeValue("LastName"));
                    logger.debug((Object)fetchResp.getAttributeValue("FullName"));
                    logger.debug((Object)fetchResp.getAttributeValue("RealmID"));
                }
                return verified;
            }
        }
        catch (OpenIDException e) {
            throw new OpenIdException("OpenIDException caught in verifyResponse: " + e.toString());
        }
        logger.error((Object)"OpenID verified is null. Verification failed.");
        return null;
    }

    public ObjectStoreHelper getObjectStoreHelper() {
        return this.objectStoreHelper;
    }

    public void setObjectStoreHelper(ObjectStoreHelper objectStoreHelper) {
        this.objectStoreHelper = objectStoreHelper;
    }
}

