/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import org.apache.commons.lang.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.mule.modules.quickbooks.api.exception.ExceptionInfo;
import org.mule.modules.quickbooks.api.exception.QuickBooksExpiredTokenException;
import org.mule.modules.quickbooks.api.exception.QuickBooksRuntimeException;
import org.mule.modules.quickbooks.api.oauth.OAuthCredentials;
import org.mule.modules.quickbooks.utils.MessageUtils;
import org.mule.modules.utils.MuleSoftException;

public abstract class AbstractQuickBooksClientOAuth {
    private static final String APP_CENTER_URI = "https://appcenter.intuit.com/api/v1/user/current";
    private static final String BLUE_DOT_MENU_URI = "https://appcenter.intuit.com/api/v1/Account/AppMenu";
    private static final String DISCONNECT_API_URI = "https://appcenter.intuit.com/api/v1/Connection/Disconnect";
    private static final String RECONNECT_API_URI = "https://appcenter.intuit.com/api/v1/Connection/Reconnect";
    private static final Logger LOGGER = Logger.getLogger(AbstractQuickBooksClientOAuth.class);
    protected Integer resultsPerPage = 999;
    protected String baseUri;
    protected final HttpClient client = AbstractQuickBooksClientOAuth.getThreadSafeClient();
    private String consumerKey;
    private String consumerSecret;
    private String appKey;

    public static DefaultHttpClient getThreadSafeClient() {
        DefaultHttpClient client = new DefaultHttpClient();
        ClientConnectionManager mgr = client.getConnectionManager();
        HttpParams params = client.getParams();
        client = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(params, mgr.getSchemeRegistry()), params);
        client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > 3) {
                    LOGGER.warn((Object)"Maximum tries reached for client http pool ");
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    LOGGER.warn((Object)("No response from server on " + executionCount + " call"));
                    return true;
                }
                return false;
            }
        });
        return client;
    }

    protected void init(String baseUri, String consumerKey, String consumerSecret, String appKey) {
        Validate.notEmpty((String)baseUri);
        this.baseUri = baseUri;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.appKey = appKey;
    }

    protected Object makeARequestToQuickbooks(HttpUriRequest httpRequest, OAuthCredentials credentials, boolean rawResponse) {
        CommonsHttpOAuthConsumer postConsumer = new CommonsHttpOAuthConsumer(this.getConsumerKey(), this.getConsumerSecret());
        postConsumer.setMessageSigner((OAuthMessageSigner)new HmacSha1MessageSigner());
        postConsumer.setTokenWithSecret(credentials.getAccessToken(), credentials.getAccessTokenSecret());
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("## Signing HttpRequest: %s", httpRequest.getURI().toString()));
            }
            postConsumer.sign((Object)httpRequest);
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
        BufferedReader br = null;
        StringBuffer responseBody = null;
        try {
            String readLine;
            HttpResponse response = this.client.execute(httpRequest);
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            responseBody = new StringBuffer();
            while ((readLine = br.readLine()) != null) {
                responseBody.append(readLine).append(System.getProperty("line.separator"));
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                ExceptionInfo fault = this.getFaultInfo(responseBody.toString());
                throw new QuickBooksRuntimeException(fault);
            }
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    throw MuleSoftException.soften((Throwable)e);
                }
            }
        }
        try {
            if (rawResponse) {
                return responseBody.toString();
            }
            return this.getMessageUtilsInstance().parseResponse(responseBody.toString());
        }
        catch (JAXBException e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    protected abstract ExceptionInfo getFaultInfo(String var1) throws JAXBException;

    protected abstract MessageUtils getMessageUtilsInstance();

    protected void prepareToPost(Object obj, HttpUriRequest httpRequest) {
        JAXBElement jaxbElement = this.getMessageUtilsInstance().createJaxbElement(obj);
        try {
            String documentToPost = this.getMessageUtilsInstance().getXmlDocument((JAXBElement<? extends Object>)jaxbElement);
            ByteArrayInputStream payLoad = new ByteArrayInputStream(documentToPost.getBytes());
            InputStreamEntity entity = new InputStreamEntity((InputStream)payLoad, -1L);
            ((HttpPost)httpRequest).setEntity((HttpEntity)entity);
        }
        catch (Exception e) {
            throw MuleSoftException.soften((Throwable)e);
        }
    }

    public void setResultsPerPage(Integer resultsPerPage) {
        if (resultsPerPage > 999 || resultsPerPage < 10) {
            throw new IllegalArgumentException("Results Per Page must be a number between 10 and 999");
        }
        this.resultsPerPage = resultsPerPage;
    }

    protected void destroyAccessToken(OAuthCredentials credentials) {
        credentials.setAccessToken("invalidToken");
    }

    protected <T> T retrieveUserInformation(OAuthCredentials credentials) {
        HttpGet httpRequest = new HttpGet(APP_CENTER_URI);
        try {
            return (T)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                this.destroyAccessToken(credentials);
                return this.retrieveUserInformation(credentials);
            }
            throw e;
        }
    }

    protected <T> T getBlueDotMenu(OAuthCredentials credentials) {
        HttpGet httpRequest = new HttpGet(BLUE_DOT_MENU_URI);
        try {
            return (T)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, true);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                throw new QuickBooksExpiredTokenException(e);
            }
            throw e;
        }
    }

    protected <T> T disconnectFromQB(OAuthCredentials credentials) {
        HttpGet httpRequest = new HttpGet(DISCONNECT_API_URI);
        try {
            return (T)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                throw new QuickBooksExpiredTokenException(e);
            }
            throw e;
        }
    }

    protected <T> T reconnectToQB(OAuthCredentials credentials) {
        HttpGet httpRequest = new HttpGet(RECONNECT_API_URI);
        try {
            return (T)this.makeARequestToQuickbooks((HttpUriRequest)httpRequest, credentials, false);
        }
        catch (QuickBooksRuntimeException e) {
            if (e.isAExpiredTokenFault()) {
                throw new QuickBooksExpiredTokenException(e);
            }
            throw e;
        }
    }

    protected Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}

