/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api;

import java.io.Serializable;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;

public class ObjectStoreHelper {
    private ObjectStore objectStore;

    public ObjectStoreHelper() {
    }

    public ObjectStoreHelper(ObjectStore objectStore) {
        this.setObjectStore(objectStore);
    }

    public Object retrieve(String key) throws ObjectStoreException {
        Serializable ret = this.objectStore.retrieve((Serializable)((Object)key));
        if (ret == null) {
            throw new ObjectDoesNotExistException();
        }
        return ret;
    }

    public void store(String key, Serializable value, boolean overwrite) throws ObjectStoreException {
        try {
            this.objectStore.store((Serializable)((Object)key), value);
        }
        catch (ObjectAlreadyExistsException e) {
            if (overwrite) {
                this.objectStore.remove((Serializable)((Object)key));
                this.objectStore.store((Serializable)((Object)key), value);
            }
            throw e;
        }
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }
}

