/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.api.gateway.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import net.sf.staccatocommons.lang.SoftException;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.commonshttp.CommonsHttpOAuthProvider;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.SigningStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.mule.modules.quickbooks.api.gateway.OAuthCredentialsStorage;

public class OAuthGateway {
    private final OAuthConsumer consumer;
    private final OAuthProvider provider;
    private final OAuthCredentialsStorage client;

    public OAuthGateway(OAuthCredentialsStorage client) {
        this.client = client;
        this.consumer = new CommonsHttpOAuthConsumer(client.getConsumerKey(), client.getConsumerSecret());
        this.provider = new CommonsHttpOAuthProvider(client.getRequestTokenURL(), client.getAccessTokenURL(), client.getAuthorizeURL());
    }

    public OAuthGateway(OAuthCredentialsStorage client, OAuthMessageSigner messageSigner) {
        this(client);
        this.consumer.setMessageSigner(messageSigner);
    }

    public OAuthGateway(OAuthCredentialsStorage client, SigningStrategy signingStrategy) {
        this(client);
        this.consumer.setSigningStrategy(signingStrategy);
    }

    public OAuthGateway(OAuthCredentialsStorage client, OAuthMessageSigner messageSigner, SigningStrategy signingStrategy) {
        this(client);
        this.consumer.setMessageSigner(messageSigner);
        this.consumer.setSigningStrategy(signingStrategy);
    }

    public final String getAuthenticationURL() throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        String authUrl = this.provider.retrieveRequestToken(this.consumer, this.client.getCallBackURL(), new String[0]);
        this.client.setRequestToken(this.consumer.getToken());
        this.client.setRequestTokenSecret(this.consumer.getTokenSecret());
        return authUrl;
    }

    public final void finishAuthentication(String verifier) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        String requestToken = this.client.getRequestToken();
        String requestTokenSecret = this.client.getRequestTokenSecret();
        this.consumer.setTokenWithSecret(requestToken, requestTokenSecret);
        this.provider.setOAuth10a(true);
        this.provider.retrieveAccessToken(this.consumer, verifier, new String[0]);
        String token = this.consumer.getToken();
        String tokenSecret = this.consumer.getTokenSecret();
        this.client.setToken(token);
        this.client.setTokenSecret(tokenSecret);
    }

    public final OAuthConsumer getConsumer() {
        if (this.client.isAuthenticated() && this.consumer.getToken() == null || this.consumer.getTokenSecret() == null) {
            this.consumer.setTokenWithSecret(this.client.getToken(), this.client.getTokenSecret());
        }
        return this.consumer;
    }

    private static String getUrlContentSigned(OAuthConsumer consumer, String url, HttpParameters additionalParameters) {
        try {
            HttpGet request = new HttpGet(url);
            consumer.setAdditionalParameters(additionalParameters);
            consumer.sign((Object)request);
            HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)request);
            return OAuthGateway.parseContent(response);
        }
        catch (Exception e) {
            throw SoftException.soften((Throwable)e);
        }
    }

    public static String getUrlContentSigned(OAuthConsumer consumer, String url) {
        return OAuthGateway.getUrlContentSigned(consumer, url, null);
    }

    public static String getUrlContentUnsigned(String url) throws ClientProtocolException, IOException {
        HttpGet request = new HttpGet(url);
        HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)request);
        return OAuthGateway.parseContent(response);
    }

    public static String postUrlContentSigned(OAuthConsumer consumer, String url, String content) {
        try {
            HttpPost request = new HttpPost(url);
            request.setEntity((HttpEntity)new StringEntity(content));
            consumer.sign((Object)request);
            HttpResponse response = new DefaultHttpClient().execute((HttpUriRequest)request);
            return OAuthGateway.parseContent(response);
        }
        catch (Exception e) {
            throw SoftException.soften((Throwable)e);
        }
    }

    private static String parseContent(HttpResponse response) throws IOException, UnsupportedEncodingException {
        String line;
        InputStream is = response.getEntity().getContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String str = "";
        while ((line = reader.readLine()) != null) {
            str = str + "\n" + line;
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(str);
        }
        return str;
    }

    public final String getOAuthToken(String serviceProviderID, String ippId, String pseudoRealmId) {
        HttpParameters additionalParameters = new HttpParameters();
        additionalParameters.put("xoauth_service_provider_id", serviceProviderID);
        additionalParameters.put("xoauth_auth_id_pseudonym", ippId);
        additionalParameters.put("xoauth_realm_id_pseudonym", pseudoRealmId);
        return OAuthGateway.getUrlContentSigned(this.getConsumer(), "https://oauth.intuit.com/oauth/v1/get_access_token_by_intuit_pseudonym", additionalParameters);
    }
}

