/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.quickbooks.utils;

import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class QBDateAdapter
extends XmlAdapter<String, Date> {
    private DateTimeFormatter dateTimeFormatter;

    public QBDateAdapter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        DateTimeParser[] parsers = new DateTimeParser[]{ISODateTimeFormat.dateTimeNoMillis().getParser(), ISODateTimeFormat.dateTime().getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-ddZ").withZone(DateTimeZone.getDefault()).getParser()};
        builder.append(ISODateTimeFormat.dateTimeNoMillis().getPrinter(), parsers);
        this.dateTimeFormatter = builder.toFormatter();
    }

    public String marshal(Date date) throws Exception {
        return new DateTime((Object)date).toString(this.dateTimeFormatter);
    }

    public Date unmarshal(String date) throws Exception {
        if (date == null) {
            return null;
        }
        return this.dateTimeFormatter.parseDateTime(date).toDate();
    }
}

