/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import com.mulesoft.modules.oauth2.provider.api.client.ObjectStoreClientStore;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStore;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.code.ObjectStoreAuthorizationCode;
import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.ObjectStoreAccessAndRefreshTokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.api.token.TokenStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.StringStartsWith;
import org.junit.Rule;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpHeaders;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public abstract class AbstractOAuth2ProviderModuleTestCase
extends MuleArtifactFunctionalTestCase {
    protected static final String TEST_CLIENT_OPTIONAL_PRINCIPAL = "clusr";
    public static final String TEST_REDIRECT_URI = "http://fake/redirect";
    protected static final String TEST_AUTHORIZATION_CODE = "__valid__";
    protected static final String TEST_RESOURCE_OWNER_USERNAME = "rousr";
    protected static final String TEST_RESOURCE_OWNER_PASSWORD = "ropwd+%";
    protected static final String TEST_CLIENT_ID = "clientId1";
    protected static final String TEST_CLIENT_SECRET = "clientSecret1";
    protected static final String TEST_CLIENT_PASSWORD = "clpwd+%";
    protected static final String TEST_SCOPE = "test_scope";
    protected static final String PROTECTED_RESOURCE_CONTENT = "accessing::protected_resource";
    protected static final String PROTECTED_RESOURCE_PATH = "/protected";
    protected static final String USER_SCOPE = "USER";
    protected static final String ADMIN_SCOPE = "ADMIN";
    private static final String DEFAULT_CLIENT_OBJECT_STORE_NAME = "clientObjectStore";
    private static final String DEFAULT_ACCESS_TOKEN_OBJECT_STORE_NAME = "tokenObjectStore";
    private static final String DEFAULT_REFRESH_TOKEN_OBJECT_STORE_NAME = "refreshTokenObjectStore";
    private static final String DEFAULT_AUTHORIZATION_OBJECT_STORE = "authorizationCodeObjectStore";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty mUnitDisableInitialStateManagerProperty = new SystemProperty("munit.disable.initial.state.manager", "true");
    @Inject
    protected Registry registry;
    protected ClientStore clientStore;
    protected AuthorizationCodeStore authorizationCodeStore;
    protected TokenStore tokenStore;
    protected HttpClient httpClient;
    protected Client client;
    protected AuthorizationCodeStoreHolder authorizationCodeStoreHolder;

    protected String getProtocol() {
        return "http";
    }

    protected String getCommonConfigFile() {
        return "common-config.xml";
    }

    protected abstract String doGetConfigFile();

    protected String[] getConfigFiles() {
        return new String[]{this.getCommonConfigFile(), this.doGetConfigFile()};
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.httpClient = new HttpClient();
        this.clientStore = new ObjectStoreClientStore();
        ((ObjectStoreClientStore)this.clientStore).setObjectStore((ObjectStore)this.registry.lookupByName(DEFAULT_CLIENT_OBJECT_STORE_NAME).get());
        this.tokenStore = new ObjectStoreAccessAndRefreshTokenStore();
        ((ObjectStoreAccessAndRefreshTokenStore)this.tokenStore).setAccessTokenObjectStore((ObjectStore)this.registry.lookupByName(DEFAULT_ACCESS_TOKEN_OBJECT_STORE_NAME).get());
        ((ObjectStoreAccessAndRefreshTokenStore)this.tokenStore).setRefreshTokenObjectStore((ObjectStore)this.registry.lookupByName(DEFAULT_REFRESH_TOKEN_OBJECT_STORE_NAME).get());
        this.authorizationCodeStore = new ObjectStoreAuthorizationCode();
        ((ObjectStoreAuthorizationCode)this.authorizationCodeStore).setObjectStore((ObjectStore)this.registry.lookupByName(DEFAULT_AUTHORIZATION_OBJECT_STORE).get());
        this.initializeClientObjectStore();
        this.initializeAuthorizationCodeObjectStore();
    }

    protected void initializeClientObjectStore() throws OAuth2Exception {
        this.setupClient(TEST_CLIENT_ID, TEST_CLIENT_OPTIONAL_PRINCIPAL);
    }

    protected void setupClient(String id, String principal) throws OAuth2Exception {
        this.client = new Client(id, TEST_CLIENT_SECRET, ClientType.CONFIDENTIAL, null, null, null);
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.client.getRedirectUris().add(TEST_REDIRECT_URI);
        this.client.setPrincipal(principal);
        this.clientStore.addClient(this.client, false);
    }

    protected Map<String, Object> getContentAsMap(HttpResponse response) throws IOException {
        return (Map)new Gson().fromJson(IOUtils.toString((InputStream)response.getEntity().getContent()), new TypeToken<Map<String, Object>>(){}.getType());
    }

    protected Map<String, Object> getContentAsMap(HttpMethod method) throws IOException {
        return (Map)new Gson().fromJson(method.getResponseBodyAsString(), new TypeToken<Map<String, Object>>(){}.getType());
    }

    protected void initializeAuthorizationCodeObjectStore() throws OAuth2Exception {
        this.createTestAuthorizationCode();
    }

    protected void createTestAuthorizationCode() throws OAuth2Exception {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(TEST_CLIENT_ID, Constants.ResponseType.CODE, TEST_REDIRECT_URI, this.getResourceOwnerAuthentication());
        this.authorizationCodeStoreHolder = new AuthorizationCodeStoreHolder(TEST_AUTHORIZATION_CODE, authorizationRequest);
        this.authorizationCodeStore.store(this.authorizationCodeStoreHolder);
    }

    protected void updateAuthorizationCodeInOS() {
        this.authorizationCodeStore.store(this.authorizationCodeStoreHolder);
    }

    private ResourceOwnerAuthentication getResourceOwnerAuthentication() {
        return new ResourceOwnerAuthentication.Builder().withCredentials((Object)new DefaultMuleCredentials(TEST_RESOURCE_OWNER_USERNAME, TEST_RESOURCE_OWNER_PASSWORD.toCharArray())).build();
    }

    protected AccessTokenStoreHolder addAccessTokenToStore(String accessToken) throws OAuth2Exception {
        return this.addAccessTokenToStore(accessToken, null);
    }

    protected AccessTokenStoreHolder addAccessTokenToStore(String accessToken, String refreshToken) throws OAuth2Exception {
        Token token = new Token.Builder(TEST_CLIENT_ID, accessToken).withRefreshToken(refreshToken).withExpirationInterval(5L, TimeUnit.SECONDS).build();
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(TEST_CLIENT_ID, Constants.ResponseType.CODE, TEST_REDIRECT_URI, this.getResourceOwnerAuthentication());
        AccessTokenStoreHolder accessTokenStoreHolder = new AccessTokenStoreHolder(token, authorizationRequest, null);
        this.tokenStore.store(accessTokenStoreHolder);
        return accessTokenStoreHolder;
    }

    protected void updateAccessTokenHolderInOS(AccessTokenStoreHolder accessTokenStoreHolder) {
        this.tokenStore.store(accessTokenStoreHolder);
    }

    protected MuleContext getMuleContextOfTestedApplication() {
        return AbstractMuleContextTestCase.muleContext;
    }

    protected void assertHasFormFieldContaining(String htmlBody, String value) {
        MatcherAssert.assertThat((String)"form value not found", (Object)htmlBody, (Matcher)Matchers.containsString((String)("value=\"" + value + "\"")));
    }

    protected String getAuthorizationEndpointUrl() {
        return this.buildURL("/authorize");
    }

    protected String getTokenEndpointURL() {
        return this.buildURL("/token");
    }

    protected String getProtectedResourceURL(String path) {
        return this.buildURL(path);
    }

    protected String buildURL(String path) {
        return this.getProtocol() + "://localhost:" + this.port.getNumber() + path;
    }

    protected void executeHttpMethodExpectingStatus(HttpMethod method, int expectedStatusCode) throws IOException {
        this.httpClient.executeMethod(method);
        MatcherAssert.assertThat((String)("Expected another status code for response: " + method.getResponseBodyAsString()), (Object)method.getStatusCode(), (Matcher)Matchers.equalTo((Object)expectedStatusCode));
    }

    protected String getHeader(HttpResponse response, String headerKey) {
        return response.getHeaders(headerKey)[0].getValue();
    }

    protected Map<String, List<String>> validateSuccessfulLoginResponse(HttpMethod method, String grantType) throws UnsupportedEncodingException, URISyntaxException {
        return this.validateSuccessfulLoginResponse(method.getResponseHeader("Location").getValue(), grantType);
    }

    protected Map<String, List<String>> validateSuccessfulLoginResponse(HttpResponse response, String grantType) throws UnsupportedEncodingException, URISyntaxException {
        return this.validateSuccessfulLoginResponse(this.getHeader(response, "Location"), grantType);
    }

    protected Map<String, List<String>> validateSuccessfulLoginResponse(String location, String grantType) throws UnsupportedEncodingException, URISyntaxException {
        MatcherAssert.assertThat((Object)location, (Matcher)StringStartsWith.startsWith((String)TEST_REDIRECT_URI));
        URI locationUri = new URI(location);
        if ("code".equals(grantType)) {
            MatcherAssert.assertThat((String)("code grant type location has query: " + locationUri), (Object)locationUri.getQuery(), (Matcher)IsNull.notNullValue());
        } else if ("access_token".equals(grantType)) {
            MatcherAssert.assertThat((String)("token grant type location has no query: " + locationUri), (Object)locationUri.getQuery(), (Matcher)Matchers.nullValue());
            MatcherAssert.assertThat((String)("token grant type location has fragment: " + locationUri), (Object)locationUri.getFragment(), (Matcher)IsNull.notNullValue());
        }
        Map<String, List<String>> urlParameters = AbstractOAuth2ProviderModuleTestCase.decodeParameters(location);
        List<String> grant = urlParameters.get(grantType);
        MatcherAssert.assertThat((String)("Grant type " + grantType + " found in location: " + location), grant, (Matcher)Matchers.both((Matcher)Matchers.not((Matcher)IsEmptyCollection.empty())).and(IsNull.notNullValue()));
        return urlParameters;
    }

    protected Map<String, Object> validateSuccessfulTokenResponseNoScopeNoRefresh(Map<String, Object> body) throws IOException {
        return this.validateSuccessfulTokenResponseNoRefresh(body, null);
    }

    protected Map<String, Object> validateSuccessfulTokenResponseNoRefresh(Map<String, Object> body, String expectedScope) throws IOException {
        return this.validateSuccessfulTokenResponse(body, expectedScope, false);
    }

    protected Map<String, Object> validateSuccessfulTokenResponseNoScope(Map<String, Object> body, boolean hasRefreshToken) throws IOException {
        return this.validateSuccessfulTokenResponse(body, null, hasRefreshToken);
    }

    protected Map<String, Object> validateSuccessfulTokenResponse(Map<String, Object> body, String expectedScope, boolean hasRefreshToken) throws IOException {
        Map<String, Object> response = body;
        MatcherAssert.assertThat(response, (Matcher)Matchers.hasKey((Object)"access_token"));
        MatcherAssert.assertThat(response, (Matcher)Matchers.hasKey((Object)"token_type"));
        MatcherAssert.assertThat(response, (Matcher)Matchers.hasKey((Object)"expires_in"));
        if (expectedScope == null) {
            MatcherAssert.assertThat(response, (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)"scope")));
        } else {
            MatcherAssert.assertThat(response, (Matcher)Matchers.hasKey((Object)"scope"));
        }
        MatcherAssert.assertThat((Object)hasRefreshToken, (Matcher)Matchers.equalTo((Object)response.containsKey("refresh_token")));
        return response;
    }

    protected String getValidBasicAuthHeaderValue(String username, String password) throws IOException {
        return "Basic " + Base64.encodeBytes((byte[])(URLEncoder.encode(username, "UTF-8") + ":" + URLEncoder.encode(password, "UTF-8")).getBytes());
    }

    protected PostMethod postOAuthClientRequestExpectingStatus(OAuthClientRequest request, int expectedStatus) throws IOException {
        PostMethod postMethod = this.getPostOAuthClientRequest(request);
        this.executeHttpMethodExpectingStatus((HttpMethod)postMethod, expectedStatus);
        return postMethod;
    }

    protected PostMethod getPostOAuthClientRequest(OAuthClientRequest request) throws UnsupportedEncodingException {
        PostMethod postMethod = new PostMethod(request.getLocationUri());
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(request.getBody(), HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString(), Charset.defaultCharset().toString()));
        if (MapUtils.isNotEmpty((Map)request.getHeaders())) {
            for (Map.Entry header : request.getHeaders().entrySet()) {
                postMethod.setRequestHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        return postMethod;
    }

    protected GetMethod getOAuthClientRequestExpectingStatus(OAuthClientRequest request, int expectedStatus) throws IOException {
        GetMethod getMethod = new GetMethod(request.getLocationUri());
        if (MapUtils.isNotEmpty((Map)request.getHeaders())) {
            for (Map.Entry header : request.getHeaders().entrySet()) {
                getMethod.setRequestHeader((String)header.getKey(), (String)header.getValue());
            }
        }
        this.executeHttpMethodExpectingStatus((HttpMethod)getMethod, expectedStatus);
        return getMethod;
    }

    protected static Map<String, List<String>> decodeParameters(String urlOrEncodedParameters) throws UnsupportedEncodingException {
        String encodedParams = urlOrEncodedParameters;
        if (StringUtils.contains((CharSequence)urlOrEncodedParameters, (CharSequence)"?")) {
            encodedParams = StringUtils.substringAfterLast((String)encodedParams, (String)"?");
        } else if (StringUtils.contains((CharSequence)urlOrEncodedParameters, (CharSequence)"#")) {
            encodedParams = StringUtils.substringAfterLast((String)encodedParams, (String)"#");
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        for (String param : encodedParams.split("&")) {
            ArrayList<String> values;
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }
            if ((values = (ArrayList<String>)params.get(key)) == null) {
                values = new ArrayList<String>();
                params.put(key, values);
            }
            values.add(value);
        }
        return params;
    }

    protected static void assertEqualJsonObj(String expected, HttpResponse response) throws Exception {
        MatcherAssert.assertThat((Object)response.getHeaders("Content-Type")[0].getValue(), (Matcher)Matchers.equalTo((Object)"application/json"));
        AbstractOAuth2ProviderModuleTestCase.compareJsonStrings(expected, IOUtils.toString((InputStream)response.getEntity().getContent()));
    }

    protected static void assertEqualJsonObj(String expected, PostMethod postMethod) throws Exception {
        MatcherAssert.assertThat((Object)postMethod.getResponseHeaders("Content-Type")[0].getValue(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)"application/json")));
        String actualJsonString = postMethod.getResponseBodyAsString();
        AbstractOAuth2ProviderModuleTestCase.compareJsonStrings(expected, actualJsonString);
    }

    private static void compareJsonStrings(String expected, String actual) {
        JsonParser parser = new JsonParser();
        JsonElement expectedObj = parser.parse(expected);
        JsonElement actualObj = parser.parse(actual);
        MatcherAssert.assertThat((Object)actualObj, (Matcher)Is.is((Matcher)Matchers.equalTo((Object)expectedObj)));
    }

    protected void updateClientInOS() {
        this.clientStore.addClient(this.client, false);
    }

    protected void accessProtectedResource(String accessToken) throws Exception {
        this.accessProtectedResource(accessToken, PROTECTED_RESOURCE_PATH);
    }

    protected void accessProtectedResource(String accessToken, String protectedResourceEndpoint) throws Exception {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(protectedResourceEndpoint) + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 200);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)PROTECTED_RESOURCE_CONTENT)));
    }
}

