/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.token.generator.TokenGeneratorStrategy;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class CustomTokenGeneratorStrategyTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Override
    protected String doGetConfigFile() {
        return "oauth2-custom-token-generator-strategy-config.xml";
    }

    @Test
    public void customTokenGeneratorStrategyIsUsed() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").setClientSecret("clientSecret1").setCode(authorizationCode).setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        MatcherAssert.assertThat(this.getContentAsMap((HttpMethod)postToken), (Matcher)Matchers.hasEntry((Object)"access_token", (Object)"SINGLE_TOKEN"));
    }

    public static class CustomTokenGeneratorStrategy
    implements TokenGeneratorStrategy {
        public static final String TOKEN = "SINGLE_TOKEN";

        public String generateToken() {
            return TOKEN;
        }
    }
}

