/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DifferentTokenSecurityProvidersTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";
    private static final String PROTECTED_RESOURCE_PATH_2 = "/protected2";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-different-token-security-provider-config.xml";
    }

    @Test
    public void TokenGrantedByOneProviderDoesNotWorkWithOther() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 200);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
        getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH_2) + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 401);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"token not in security provider")));
    }
}

