/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import io.qameta.allure.Description;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class NoResourceOwnerSecurityProviderTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String AUTHORIZED_GRANT_TYPES = "authorizedGrantTypes";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private String name;
    @Rule
    public SystemProperty authorizedGrantTypes;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"NO_AUTHORIZED_GRANT_TYPES", new SystemProperty(AUTHORIZED_GRANT_TYPES, ""), true}, {"ONLY_CLIENT_CREDENTIALS", new SystemProperty(AUTHORIZED_GRANT_TYPES, "CLIENT_CREDENTIALS"), false}, {"ONLY_RO_GRANT_TYPE", new SystemProperty(AUTHORIZED_GRANT_TYPES, "RESOURCE_OWNER_PASSWORD_CREDENTIALS"), true}, {"MORE_THAN_ONE_WITH_CLIENT_CREDENTIALS", new SystemProperty(AUTHORIZED_GRANT_TYPES, "RESOURCE_OWNER_PASSWORD_CREDENTIALS, CLIENT_CREDENTIALS"), true}, {"MORE_THAN_ONE_NO_CLIENT_CREDENTIALS", new SystemProperty(AUTHORIZED_GRANT_TYPES, "RESOURCE_OWNER_PASSWORD_CREDENTIALS, AUTHORIZATION_CODE"), true});
    }

    public NoResourceOwnerSecurityProviderTestCase(String name, SystemProperty authorizedGrantTypes, boolean shouldFail) {
        this.name = name;
        this.authorizedGrantTypes = authorizedGrantTypes;
        if (shouldFail) {
            this.expectedException.expect(InitialisationException.class);
            this.expectedException.expectMessage("A Resource Owner Security Provided should be configured");
        }
    }

    @Override
    protected String doGetConfigFile() {
        return "no-ro-security-provider-config.xml";
    }

    @Test
    @Description(value="There is no need for configuring a Resource Owner Security Provider if onle CLIENT_CREDENTILS grant type is supported.")
    public void noROSecurityProviderWorksIfOnlyClientCredentials() throws Exception {
        this.check();
    }

    private void check() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }
}

