/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderCustomLoginPageTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Override
    protected String doGetConfigFile() {
        return "oauth2-custom-login-page-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getScopes().add("USER");
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.updateClientInOS();
    }

    @Test
    public void accessDefaultLoginPageWithScopeSuccess() throws Exception {
        String clientName = RandomStringUtils.randomAlphanumeric((int)20);
        this.client.setClientName(clientName);
        this.updateClientInOS();
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("USER").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.OK.getStatusCode());
        String responseBody = getAuthorization.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"@font-face"));
    }
}

