/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;

public class OAuth2ProviderModuleCoreSecureTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";
    private static final String CLIENT_RESTRICTED_RESOURCE_PATH = "/client_only";
    private static final String keyStorePath = "tls/clientKeystore";
    private static final String trustStorePath = "tls/trustStore";
    private static final String storePassword = "mulepassword";
    private static final String keyPassword = "mulepassword";
    private static final String protocol = "TLSv1.2";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-core-tests-https-config.xml";
    }

    @Override
    protected String getProtocol() {
        return "https";
    }

    protected static HttpResponse executeGetRequest(String url) throws IOException, GeneralSecurityException {
        HttpClient client = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false);
        HttpGet getMethod = new HttpGet(url);
        return client.execute((HttpUriRequest)getMethod);
    }

    private static HttpClient getSecureClient(boolean disableRedirectHandling) throws IOException, GeneralSecurityException {
        HttpClientBuilder clientBuilder = HttpClients.custom().setSslcontext(OAuth2ProviderModuleCoreSecureTestCase.getSslContext());
        if (disableRedirectHandling) {
            clientBuilder.disableRedirectHandling();
        }
        CloseableHttpClient secureClient = clientBuilder.build();
        return secureClient;
    }

    private static SSLContext getSslContext() throws IOException, GeneralSecurityException {
        File keyStore = FileUtils.getFile((String[])new String[]{org.mule.runtime.core.api.util.FileUtils.getResourcePath((String)keyStorePath, OAuth2ProviderModuleCoreSecureTestCase.class)});
        File trustStore = FileUtils.getFile((String[])new String[]{org.mule.runtime.core.api.util.FileUtils.getResourcePath((String)trustStorePath, OAuth2ProviderModuleCoreSecureTestCase.class)});
        char[] storePass = "mulepassword".toCharArray();
        char[] keyPass = "mulepassword".toCharArray();
        SSLContext customSslContext = SSLContexts.custom().useProtocol(protocol).loadKeyMaterial(keyStore, storePass, keyPass).loadTrustMaterial(trustStore, storePass).build();
        return customSslContext;
    }

    @Test
    public void accessLoginPageBadMethod() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildQueryMessage();
        HttpPut putAuthorization = new HttpPut(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)putAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)405));
    }

    @Test
    public void accessLoginPageEmptyRequest() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: response_type")));
    }

    @Test
    public void accessLoginPageBadResponseType() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("_bad_").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Response type '_bad_' is not supported")));
    }

    @Test
    public void accessLoginPageBadClientId() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("_bad_").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unauthorized_client")));
    }

    @Test
    public void accessLoginPageBadRedirectUri() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("_bad_").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_redirection_uri")));
    }

    @Test
    public void accessLoginPageWithScopeFailureAuthorizationCodeGrant() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("test_scope").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(true).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        String location = response.getHeaders("Location")[0].getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        URI locationUri = new URI(location);
        MatcherAssert.assertThat((String)"authorization code grant type location has query", (Object)locationUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
    }

    @Test
    public void accessLoginPageWithScopeFailureImplicitGrant() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("token").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("test_scope").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(true).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        String location = response.getHeaders("Location")[0].getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        URI locationUri = new URI(location);
        MatcherAssert.assertThat((String)"token grant type location has no query", (Object)locationUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((String)"token grant type location has fragment", (Object)locationUri.getFragment(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
    }

    @Test
    public void accessLoginPageSuccess() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildQueryMessage();
        HttpGet getAuthorization = new HttpGet(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getAuthorization);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getHeaders("Content-Type")[0].getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)MediaType.HTML.toRfcString())));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)"<html>"));
        this.assertHasFormFieldContaining(responseBody, "code");
        this.assertHasFormFieldContaining(responseBody, "clientId1");
        this.assertHasFormFieldContaining(responseBody, "http://fake/redirect");
    }

    @Test
    public void validateCredentialsNoParamProvided() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildBodyMessage();
        HttpPost postCredentials = new HttpPost(authorizationRequest.getLocationUri());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postCredentials);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)response.getHeaders("Location"), (Matcher)Matchers.emptyArray());
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: response_type")));
    }

    @Test
    public void validateCredentialsNoCredentialsProvided() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postCredentials = new HttpPost(authorizationRequest.getLocationUri());
        postCredentials.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postCredentials);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        String location = response.getHeaders("Location")[0].getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: username")));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void validateCredentialsInvalidCredentialsAuthorizationCodeGrant() throws Exception {
        this.doValidateCredentialsInvalidCredentials("code");
    }

    @Test
    public void validateCredentialsInvalidCredentialsImplicitGrant() throws Exception {
        this.doValidateCredentialsInvalidCredentials("token");
    }

    @Test
    public void validateCredentialsValidCredentials() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        HttpPost postCredentials = new HttpPost(authorizationRequest.getLocationUri());
        postCredentials.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postCredentials);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        this.validateSuccessfulLoginResponse(response, "code");
    }

    @Test
    public void validateCredentialsValidCredentialsWithState() throws Exception {
        String testState = RandomStringUtils.randomAlphanumeric((int)10);
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setState(testState).buildBodyMessage();
        HttpPost postCredentials = new HttpPost(authorizationRequest.getLocationUri());
        postCredentials.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postCredentials);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        Map<String, List<String>> urlParameters = this.validateSuccessfulLoginResponse(response, "code");
        MatcherAssert.assertThat((Object)urlParameters.get("state").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testState)));
    }

    @Test
    public void tokenExchangeEmptyRequest() throws Exception {
        HttpPost postToken = new HttpPost(this.getTokenEndpointURL());
        postToken.setHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Missing mandatory parameter: grant_type\"}", response);
    }

    @Test
    public void tokenExchangeUnsupportedGrantType() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.NONE).buildBodyMessage();
        HttpPost postToken = new HttpPost(this.getTokenEndpointURL());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"unsupported_grant_type\",\"error_description\":\"Grant type 'none' is not supported\"}", response);
    }

    @Test
    public void tokenExchangeNoCredentials() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        HttpPost postToken = new HttpPost(this.getTokenEndpointURL());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_client\",\"error_description\":\"Invalid credentials\"}", response);
    }

    @Test
    public void tokenExchangeBrokenAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", "_broken_");
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Invalid 'Authorization' header\"}", response);
    }

    @Test
    public void tokenExchangeBadAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("_bad_", "_bad_"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)"\"error\":\"invalid_client\""));
    }

    @Test
    public void tokenExchangeInvalidRequestUri() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").setCode("_ignored_").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_redirection_uri\",\"error_description\":\"Missing mandatory parameter: redirect_uri\"}", response);
    }

    @Test
    public void tokenExchangeInvalidGrant() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").setCode("_invalid_").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_grant\",\"error_description\":\"Authorization code is invalid or expired\"}", response);
    }

    @Test
    public void tokenExchangeMultipleAuthentications() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setRedirectURI("http://fake/redirect").setClientId("clientId1").setClientSecret("clientSecret1").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Multiple client authentications found\"}", response);
    }

    @Test
    public void tokenExchangeExpiredAuthorizationCode() throws Exception {
        this.tokenExchangeValidUsernamePassword();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_grant\",\"error_description\":\"Authorization code is invalid or expired\"}", response);
    }

    @Test
    public void tokenExchangeClientNotFoundInSecurityProvider() throws Exception {
        this.client.setPrincipal(null);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "_bad_"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        OAuth2ProviderModuleCoreSecureTestCase.assertEqualJsonObj("{\"error\":\"invalid_client\",\"error_description\":\"Invalid credentials\"}", response);
    }

    @Test
    public void tokenExchangeClientIdIsValidSecurityProviderPrincipal() throws Exception {
        this.setupClient("clusr", null);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
    }

    @Test
    public void tokenExchangeValidUsernamePassword() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
    }

    @Test
    public void tokenExchangeValidBasicAuth() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
    }

    @Test
    public void tokenExchangeValidClientSecret() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
    }

    @Test
    public void tokenExchangePublicClient() throws Exception {
        this.client.setSecret(null);
        this.client.setType(ClientType.PUBLIC);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
    }

    @Test
    public void tokenRequestBadClientAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setUsername("rousr").setPassword("ropwd+%").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("_bad_", "_bad_"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)"\"error\":\"invalid_client\""));
    }

    @Test
    public void tokenRequestBadResourceOwnerCredentials() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setUsername("rousr").setPassword("_bad_").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)400));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.containsString((String)"\"error\":\"access_denied\""));
    }

    @Test
    public void accessProtectedResourceWithoutToken() throws Exception {
        HttpGet getProtectedResource = new HttpGet(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getProtectedResource);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0].getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithBadAccessToken() throws Exception {
        HttpGet getProtectedResource = new HttpGet(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=_bad_");
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getProtectedResource);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0].getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithExpiredAccessToken() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        HttpGet getProtectedResource = new HttpGet(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getProtectedResource);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)401));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0], (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate")[0].getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithAccessTokenQueryParam() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void accessProtectedResourceWithBearerHeader() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        HttpGet getProtectedResource = new HttpGet(this.getProtectedResourceURL("/protected-with-bearer"));
        getProtectedResource.addHeader("Authorization", "Bearer " + accessToken);
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getProtectedResource);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        HttpPost postCredentials = new HttpPost(authorizationRequest.getLocationUri());
        postCredentials.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postCredentials);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse(response, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performImplicitGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("token").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        HttpPost postToken = new HttpPost(authorizationRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        Map<String, List<String>> tokenResponse = this.validateSuccessfulLoginResponse(response, "access_token");
        String accessToken = tokenResponse.get("access_token").get(0);
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performResourceOwnerPasswordCredentialsGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performClientCredentialsGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials").buildBodyMessage();
        HttpPost postToken = new HttpPost(oAuthClientRequest.getLocationUri());
        postToken.setEntity((HttpEntity)new StringEntity(oAuthClientRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        postToken.setHeader("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%"));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)postToken);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap(response));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Override
    protected void accessProtectedResource(String accessToken) throws Exception {
        HttpGet getProtectedResource = new HttpGet(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)getProtectedResource);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getHeaders("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.emptyArray()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
    }

    private void doValidateCredentialsInvalidCredentials(String responseType) throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType(responseType).setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "__BAD__").buildBodyMessage();
        HttpPost httpPost = new HttpPost(authorizationRequest.getLocationUri());
        httpPost.setEntity((HttpEntity)new StringEntity(authorizationRequest.getBody(), ContentType.APPLICATION_FORM_URLENCODED));
        HttpResponse response = OAuth2ProviderModuleCoreSecureTestCase.getSecureClient(false).execute((HttpUriRequest)httpPost);
        MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)302));
        String location = response.getHeaders("Location")[0].getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreSecureTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"access_denied")));
        String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent());
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.isEmptyString());
    }
}

