/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;

public class OAuth2ProviderModuleCoreTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String CLIENT_RESTRICTED_RESOURCE_PATH = "/client_only";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-core-tests-http-config.xml";
    }

    @Override
    protected String buildURL(String path) {
        return this.getProtocol() + "://localhost:" + this.port.getNumber() + path;
    }

    @Test
    public void accessLoginPageBadMethod() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildQueryMessage();
        PutMethod putAuthorization = new PutMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)putAuthorization, 405);
    }

    @Test
    public void accessLoginPageEmptyRequest() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 400);
        String responseBody = getAuthorization.getResponseBodyAsString();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: response_type")));
    }

    @Test
    public void accessLoginPageBadResponseType() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("_bad_").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 400);
        String responseBody = getAuthorization.getResponseBodyAsString();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Response type '_bad_' is not supported")));
    }

    @Test
    public void accessLoginPageBadClientId() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("_bad_").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 400);
        String responseBody = getAuthorization.getResponseBodyAsString();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unauthorized_client")));
    }

    @Test
    public void accessLoginPageBadRedirectUri() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("_bad_").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 400);
        String responseBody = getAuthorization.getResponseBodyAsString();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_redirection_uri")));
    }

    @Test
    public void accessLoginPageWithScopeFailureAuthorizationCodeGrant() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("test_scope").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 302);
        String location = getAuthorization.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        URI locationUri = new URI(location);
        MatcherAssert.assertThat((String)"authorization code grant type location has query", (Object)locationUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
    }

    @Test
    public void accessLoginPageWithScopeFailureImplicitGrant() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("token").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("test_scope").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 302);
        String location = getAuthorization.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        URI locationUri = new URI(location);
        MatcherAssert.assertThat((String)"token grant type location has no query", (Object)locationUri.getQuery(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((String)"token grant type location has fragment", (Object)locationUri.getFragment(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
    }

    @Test
    public void accessLoginPageSuccess() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, 200);
        MatcherAssert.assertThat((Object)getAuthorization.getResponseHeader("Content-Type").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)MediaType.HTML.toRfcString())));
        String responseBody = getAuthorization.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)CoreMatchers.containsString((String)"<html>"));
        this.assertHasFormFieldContaining(responseBody, "code");
        this.assertHasFormFieldContaining(responseBody, "clientId1");
        this.assertHasFormFieldContaining(responseBody, "http://fake/redirect");
    }

    @Test
    public void validateCredentialsNoParamProvided() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 400);
        MatcherAssert.assertThat((Object)postCredentials.getResponseHeader("Location"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        String responseBody = postCredentials.getResponseBodyAsString();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(responseBody);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"unsupported_response_type")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: response_type")));
    }

    @Test
    public void validateCredentialsNoCredentialsProvided() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        String location = postCredentials.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: username")));
        String responseBody = postCredentials.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.isEmptyString());
    }

    @Test
    public void validateCredentialsInvalidCredentialsAuthorizationCodeGrant() throws Exception {
        this.doValidateCredentialsInvalidCredentials("code");
    }

    @Test
    public void validateCredentialsInvalidCredentialsImplicitGrant() throws Exception {
        this.doValidateCredentialsInvalidCredentials("token");
    }

    @Test
    public void validateCredentialsValidCredentials() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
    }

    @Test
    public void validateCredentialsValidCredentialsWithState() throws Exception {
        String testState = RandomStringUtils.randomAlphanumeric((int)10);
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setState(testState).buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> urlParameters = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        MatcherAssert.assertThat((Object)urlParameters.get("state").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)testState)));
    }

    @Test
    public void tokenExchangeEmptyRequest() throws Exception {
        PostMethod postToken = new PostMethod(this.getTokenEndpointURL());
        postToken.setRequestHeader("Content-Type", HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString());
        this.executeHttpMethodExpectingStatus((HttpMethod)postToken, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Missing mandatory parameter: grant_type\"}", postToken);
    }

    @Test
    public void tokenExchangeUnsupportedGrantType() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.NONE).buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"unsupported_grant_type\",\"error_description\":\"Grant type 'none' is not supported\"}", postToken);
    }

    @Test
    public void tokenExchangeNoCredentials() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_client\",\"error_description\":\"Invalid credentials\"}", postToken);
    }

    @Test
    public void tokenExchangeBrokenAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", "_broken_"));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Invalid 'Authorization' header\"}", postToken);
    }

    @Test
    public void tokenExchangeBadAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("_bad_", "_bad_")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 401);
        MatcherAssert.assertThat((Object)postToken.getResponseBodyAsString(), (Matcher)CoreMatchers.containsString((String)"\"error\":\"invalid_client\""));
    }

    @Test
    public void tokenExchangeInvalidRequestUri() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").setCode("_ignored_").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_redirection_uri\",\"error_description\":\"Missing mandatory parameter: redirect_uri\"}", postToken);
    }

    @Test
    public void tokenExchangeInvalidGrant() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId("clientId1").setCode("_invalid_").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_grant\",\"error_description\":\"Authorization code is invalid or expired\"}", postToken);
    }

    @Test
    public void tokenExchangeMultipleAuthentications() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("USER").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setRedirectURI("http://fake/redirect").setClientId("clientId1").setClientSecret("clientSecret1").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_request\",\"error_description\":\"Multiple client authentications found\"}", postToken);
    }

    @Test
    public void tokenExchangeExpiredAuthorizationCode() throws Exception {
        this.tokenExchangeValidUsernamePassword();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_grant\",\"error_description\":\"Authorization code is invalid or expired\"}", postToken);
    }

    @Test
    public void tokenExchangeClientNotFoundInSecurityProvider() throws Exception {
        this.client.setPrincipal(null);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "_bad_")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 401);
        MatcherAssert.assertThat((Object)postToken.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        OAuth2ProviderModuleCoreTestCase.assertEqualJsonObj("{\"error\":\"invalid_client\",\"error_description\":\"Invalid credentials\"}", postToken);
    }

    @Test
    public void tokenExchangeClientIdIsValidSecurityProviderPrincipal() throws Exception {
        this.setupClient("clusr", null);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }

    @Test
    public void tokenExchangeValidUsernamePassword() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }

    @Test
    public void tokenExchangeValidBasicAuth() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }

    @Test
    public void tokenExchangeValidClientSecret() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }

    @Test
    public void tokenExchangePublicClient() throws Exception {
        this.client.setSecret(null);
        this.client.setType(ClientType.PUBLIC);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
    }

    @Test
    public void tokenRequestBadClientAuthorization() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setUsername("rousr").setPassword("ropwd+%").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("_bad_", "_bad_")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 401);
        MatcherAssert.assertThat((Object)postToken.getResponseBodyAsString(), (Matcher)CoreMatchers.containsString((String)"\"error\":\"invalid_client\""));
    }

    @Test
    public void tokenRequestBadResourceOwnerCredentials() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setUsername("rousr").setPassword("_bad_").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 400);
        MatcherAssert.assertThat((Object)postToken.getResponseBodyAsString(), (Matcher)CoreMatchers.containsString((String)"\"error\":\"access_denied\""));
    }

    @Test
    public void accessProtectedResourceWithoutToken() throws Exception {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected"));
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getStatusCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithBadAccessToken() throws Exception {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected") + "?access_token=_bad_");
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 401);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithExpiredAccessToken() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected") + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 401);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessProtectedResourceWithAccessTokenQueryParam() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void accessProtectedResourceWithBearerHeader() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected-with-bearer"));
        getProtectedResource.addRequestHeader("Authorization", "Bearer " + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, 200);
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performImplicitGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("token").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> tokenResponse = this.validateSuccessfulLoginResponse((HttpMethod)postToken, "access_token");
        String accessToken = tokenResponse.get("access_token").get(0);
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performResourceOwnerPasswordCredentialsGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performClientCredentialsGrantOAuth2DanceAndAccessProtectedResourceWithClientPassword() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void performClientCredentialsGrantOAuth2DanceAndAccessProtectedResourceWithClientSecret() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clientSecret1")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }

    @Test
    public void multipleInvalidCredentialsAreRejected() throws Exception {
        String responseType = "code";
        this.doValidateCredentialsInvalidCredentials("code");
        this.doValidateCredentialsInvalidCredentials("code");
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "__BAD__").buildBodyMessage();
        this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.TOO_MANY_REQUESTS.getStatusCode());
    }

    @Test
    public void getAccessTokenWithGETAndFail() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", GrantType.AUTHORIZATION_CODE.toString()).setParameter("code", "useless_authentication_code").setParameter("client_id", "clientId1").setParameter("client_secret", "clientSecret1").setParameter("redirect_uri", "http://fake/redirect").buildQueryMessage();
        this.getOAuthClientRequestExpectingStatus(oAuthClientRequest, 405);
    }

    @Test
    public void tokenAttributesHaveCorrectValues() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        CoreEvent event = ((FlowRunner)this.flowRunner("testAttributes").withVariable("ACCESS_TOKEN", (Object)accessToken)).run();
        Long tokenTtl = (Long)((TypedValue)event.getVariables().get("tokenTtl")).getValue();
        MatcherAssert.assertThat((Object)tokenTtl, (Matcher)Matchers.is((Matcher)Matchers.both((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(5000000000L))).and(Matchers.lessThan((Comparable)Long.valueOf(10000000000L)))));
        event = ((FlowRunner)this.flowRunner("testAttributes").withVariable("ACCESS_TOKEN", (Object)accessToken)).run();
        Long tokenTtl2 = (Long)((TypedValue)event.getVariables().get("tokenTtl")).getValue();
        MatcherAssert.assertThat((Object)tokenTtl2, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)tokenTtl)));
    }

    @Test
    public void payloadIsCorrectlyGenerated() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        CoreEvent event = ((FlowRunner)this.flowRunner("validateToken").withVariable("ACCESS_TOKEN", (Object)accessToken)).run();
        Map payload = (Map)new Gson().fromJson(event.getMessage().getPayload().getValue().toString(), new TypeToken<Map<String, String>>(){}.getType());
        MatcherAssert.assertThat((Object)payload, (Matcher)AllOf.allOf((Matcher)Matchers.hasKey((Object)"expires_in"), (Matcher)Matchers.hasEntry((Object)"client_id", (Object)"clientId1"), (Matcher)Matchers.hasEntry((Object)"username", (Object)"rousr"), (Matcher)Matchers.hasEntry((Object)"scope", (Object)"")));
    }

    private void doValidateCredentialsInvalidCredentials(String responseType) throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType(responseType).setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "__BAD__").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        String location = postCredentials.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleCoreTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"access_denied")));
        String responseBody = postCredentials.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.isEmptyString());
    }
}

