/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OAuth2ProviderModuleCreateClientTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-create-client-tests-http-config.xml";
    }

    @Override
    protected MuleContext getMuleContextOfTestedApplication() {
        return AbstractMuleContextTestCase.muleContext;
    }

    @Override
    protected String buildURL(String path) {
        return this.getProtocol() + "://localhost:" + this.port.getNumber() + path;
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.registerClient("registerClient", "CONFIDENTIAL", "clientSecret1");
        String accessToken = this.getAccessToken();
        this.accessProtectedResource(accessToken);
        this.deleteClient();
    }

    @Test
    public void registerPublicClientWithNoSecurityProvider() throws Exception {
        this.registerClient("registerClientNoSecurityProvider", "PUBLIC", null);
    }

    @Test
    public void registerConfidentialClientWithSecretNoSecurityProvider() throws Exception {
        this.registerClient("registerClientNoSecurityProvider", "CONFIDENTIAL", "clientSecret1");
    }

    private String getAccessToken() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        return accessToken;
    }

    private void deleteClient() throws Exception {
        ((FlowRunner)this.flowRunner("deleteClient").withVariable("CLIENT_ID", (Object)"clientId1")).run();
    }

    private void registerClient(String flow, String clientType, String clientSecret) throws Exception {
        ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner(flow).withVariable("CLIENT_ID", (Object)"clientId1")).withVariable("CLIENT_SECRET", (Object)clientSecret)).withVariable("CLIENT_PRINCIPAL", (Object)"clusr")).withVariable("CLIENT_TYPE", (Object)clientType)).withVariable("AUTHORIZED_GRANT_TYPES", Collections.singletonList("AUTHORIZATION_CODE"))).withVariable("REDIRECT_URIS", Collections.singletonList("http://fake/redirect"))).withPayload((Object)this.client)).run();
    }
}

