/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleDefaultLoginPageTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Override
    protected String doGetConfigFile() {
        return "oauth2-default-login-page-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getScopes().add("USER");
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.updateClientInOS();
    }

    @Test
    public void accessDefaultLoginPageWithScopeSuccess() throws Exception {
        String clientName = RandomStringUtils.randomAlphanumeric((int)20);
        this.client.setClientName(clientName);
        this.updateClientInOS();
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("USER").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getAuthorization.getResponseHeader("Content-Type").getValue(), (Matcher)Matchers.is((Matcher)CoreMatchers.equalTo((Object)MediaType.HTML.toRfcString())));
        String responseBody = getAuthorization.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)AllOf.allOf((Matcher)CoreMatchers.containsString((String)"<html>"), (Matcher)CoreMatchers.containsString((String)"<li>USER</li>"), (Matcher)CoreMatchers.containsString((String)clientName), (Matcher)CoreMatchers.containsString((String)"Popular Social Network")));
        this.assertHasFormFieldContaining(responseBody, "code");
        this.assertHasFormFieldContaining(responseBody, "clientId1");
        this.assertHasFormFieldContaining(responseBody, "http://fake/redirect");
        this.assertHasFormFieldContaining(responseBody, "USER");
    }
}

