/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Test;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class OAuth2ProviderModuleDefaultStoresTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-default-stores-tests-http-config.xml";
    }

    @Override
    protected MuleContext getMuleContextOfTestedApplication() {
        return AbstractMuleContextTestCase.muleContext;
    }

    @Override
    protected String buildURL(String path) {
        return this.getProtocol() + "://localhost:" + this.port.getNumber() + path;
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh((Map)new Gson().fromJson(postToken.getResponseBodyAsString(), new TypeToken<Map<String, Object>>(){}.getType()));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
    }
}

