/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleInvalidAccessTokenExceptionFlowTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String INVALID_ACCESS_TOKEN = "invalid";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-invalid-exception-flow-http-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getScopes().add("USER");
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.updateClientInOS();
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResources() throws Exception {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected/preFlow") + "?access_token=" + INVALID_ACCESS_TOKEN);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_access")));
    }
}

