/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import io.qameta.allure.Description;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OAuth2ProviderModuleNoClientSecurityProviderSuccessTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected String doGetConfigFile() {
        return "oauth2-no-client-security-provider-success.xml";
    }

    @Test
    @Description(value="Check that the provider works ok if there is only PUBLIC clients")
    public void provideWorksOkWithOnlyPublicClients() throws Exception {
        this.getTokenAndValidate("publicClientId", "", "/publicAuthorize", "/publicToken", "/protectedPublic");
    }

    @Test
    @Description(value="Check that the provider works ok if there is only CONFIDENTIAL clients with secrets")
    public void provideWorksOkWithConfidentialClientsAndSecret() throws Exception {
        this.getTokenAndValidate("confidentialClientId", "confidentialClientSecret", "/confidentialAuthorize", "/confidentialToken", "/protectedConfidential");
    }

    private void getTokenAndValidate(String clientID, String clientSecret, String authorizationEndpoint, String tokenEndpoint, String validationEndpoint) throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.buildURL(authorizationEndpoint)).setResponseType("code").setClientId(clientID).setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, 302);
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.buildURL(tokenEndpoint)).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId(clientID).setClientSecret(clientSecret).setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, 200);
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScopeNoRefresh(this.getContentAsMap((HttpMethod)postToken));
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken, validationEndpoint);
    }
}

