/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.exception.OAuthSystemException;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleRefreshTokenTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-refresh-token-http-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.REFRESH_TOKEN);
        this.updateClientInOS();
    }

    @Test
    public void tokenExchangeSuccess() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
    }

    @Test
    public void refreshTokenMissingToken() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken, refreshToken);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode());
    }

    @Test
    public void refreshTokenInvalidScope() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken, refreshToken);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).setScope("test_scope").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode());
        OAuth2ProviderModuleRefreshTokenTestCase.assertEqualJsonObj("{\"error\":\"invalid_scope\",\"error_description\":\"\"}", postToken);
    }

    @Test
    public void refreshTokenSuccess() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken, refreshToken);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
    }

    @Test
    public void refreshTokenReceivingGrantedScopeSuccess() throws Exception {
        this.client.getScopes().add("USER");
        this.updateClientInOS();
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        AccessTokenStoreHolder authorizationCodeStoreHolder = this.addAccessTokenToStore(accessToken, refreshToken);
        authorizationCodeStoreHolder.getAuthorizationRequest().getScopes().add("USER");
        authorizationCodeStoreHolder.getAccessToken().getScopes().add("USER");
        this.updateAccessTokenHolderInOS(authorizationCodeStoreHolder);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        this.validateSuccessfulTokenResponse(this.getContentAsMap((HttpMethod)postToken), "USER", true);
    }

    @Test
    public void refreshTokenRequestingGrantedScopeSuccess() throws Exception {
        this.client.getScopes().add("USER");
        this.updateClientInOS();
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        AccessTokenStoreHolder authorizationCodeStoreHolder = this.addAccessTokenToStore(accessToken, refreshToken);
        authorizationCodeStoreHolder.getAuthorizationRequest().getScopes().add("USER");
        authorizationCodeStoreHolder.getAccessToken().getScopes().add("USER");
        this.updateAccessTokenHolderInOS(authorizationCodeStoreHolder);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)(this.getTokenEndpointURL() + "WithUserScope")).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).setScope("USER").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        this.validateSuccessfulTokenResponse(this.getContentAsMap((HttpMethod)postToken), "USER", true);
    }

    @Test
    public void refreshTokenRequestingBeyondGrantedScopeFailure() throws Exception {
        this.client.getScopes().add("USER");
        this.updateClientInOS();
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        AccessTokenStoreHolder authorizationCodeStoreHolder = this.addAccessTokenToStore(accessToken, refreshToken);
        authorizationCodeStoreHolder.getAuthorizationRequest().getScopes().add("USER");
        authorizationCodeStoreHolder.getAccessToken().getScopes().add("USER");
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)(this.getTokenEndpointURL() + "WithUserScope")).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).setScope("USER test_scope").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode());
        OAuth2ProviderModuleRefreshTokenTestCase.assertEqualJsonObj("{\"error\":\"invalid_scope\",\"error_description\":\"\"}", postToken);
    }

    @Test
    public void performAuthorizationCodeGrantOAuth2DanceAndTestRefreshToken() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest tokenExchangeRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        this.doGetAccessTokenAndTryRefreshIt(tokenExchangeRequest);
    }

    @Test
    public void performResourceOwnerPasswordCredentialsGrantOAuth2DanceAndTestRefreshToken() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest tokenExchangeRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        tokenExchangeRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        this.doGetAccessTokenAndTryRefreshIt(tokenExchangeRequest);
    }

    private void doGetAccessTokenAndTryRefreshIt(OAuthClientRequest tokenExchangeRequest) throws IOException, OAuthSystemException, InterruptedException {
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(tokenExchangeRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
        String accessToken1 = (String)tokenResponse.get("access_token");
        String refreshToken1 = (String)tokenResponse.get("refresh_token");
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken1);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
        OAuthClientRequest refreshTokenRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken1).buildBodyMessage();
        refreshTokenRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        postToken = this.postOAuthClientRequestExpectingStatus(refreshTokenRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        tokenResponse = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
        String accessToken2 = (String)tokenResponse.get("access_token");
        String refreshToken2 = (String)tokenResponse.get("refresh_token");
        MatcherAssert.assertThat((Object)accessToken2, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)accessToken1))));
        MatcherAssert.assertThat((Object)refreshToken2, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)refreshToken1))));
        getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken2);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
    }

    @Test
    public void concurrentRefreshTokenSuccess() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        String refreshToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken, refreshToken);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        int numberOfThreads = 100;
        CountDownLatch interleavingLatch = new CountDownLatch(numberOfThreads);
        ArrayList results = new ArrayList(numberOfThreads);
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            executorService.execute(() -> {
                PostMethod method = null;
                try {
                    interleavingLatch.await();
                    method = this.getPostOAuthClientRequest(oAuthClientRequest);
                    new HttpClient().executeMethod((HttpMethod)method);
                }
                catch (Exception exception) {
                    List list = results;
                    synchronized (list) {
                        results.add(method);
                    }
                }
                finally {
                    List list = results;
                    synchronized (list) {
                        results.add(method);
                    }
                }
            });
            interleavingLatch.countDown();
        }
        executorService.shutdown();
        executorService.awaitTermination(this.getTestTimeoutSecs(), TimeUnit.SECONDS);
        ArrayList<PostMethod> okResults = new ArrayList<PostMethod>();
        ArrayList<PostMethod> failureResults = new ArrayList<PostMethod>();
        for (PostMethod method : results) {
            try {
                if (Objects.nonNull(method) && Objects.nonNull(method.getStatusCode()) && method.getStatusCode() == HttpConstants.HttpStatus.OK.getStatusCode()) {
                    okResults.add(method);
                    continue;
                }
                failureResults.add(method);
            }
            catch (Exception e) {
                failureResults.add(method);
            }
        }
        MatcherAssert.assertThat((Object)okResults.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)failureResults.size(), (Matcher)Matchers.is((Object)(numberOfThreads - 1)));
    }
}

