/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.exception.OAuthSystemException;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleRefreshTokenWithoutIssuingNewTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-refresh-token-without-issuing-new-tests-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.REFRESH_TOKEN);
        this.updateClientInOS();
    }

    @Test
    public void performAuthorizationCodeGrantOAuth2DanceAndTestRefreshToken() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest tokenExchangeRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        this.doGetAccessTokenAndTryRefreshIt(tokenExchangeRequest);
    }

    private void doGetAccessTokenAndTryRefreshIt(OAuthClientRequest tokenExchangeRequest) throws IOException, OAuthSystemException, InterruptedException {
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(tokenExchangeRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
        String accessToken1 = (String)tokenResponse.get("access_token");
        String refreshToken1 = (String)tokenResponse.get("refresh_token");
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken1);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)"accessing::protected_resource", (Matcher)CoreMatchers.equalTo((Object)getProtectedResource.getResponseBodyAsString()));
        OAuthClientRequest refreshTokenRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken1).buildBodyMessage();
        refreshTokenRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        postToken = this.postOAuthClientRequestExpectingStatus(refreshTokenRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        tokenResponse = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
        String accessToken2 = (String)tokenResponse.get("access_token");
        String refreshToken2 = (String)tokenResponse.get("refresh_token");
        MatcherAssert.assertThat((Object)accessToken2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)accessToken1)));
        MatcherAssert.assertThat((Object)refreshToken2, (Matcher)CoreMatchers.equalTo((Object)refreshToken1));
        getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken2);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)"accessing::protected_resource", (Matcher)CoreMatchers.equalTo((Object)getProtectedResource.getResponseBodyAsString()));
        Thread.sleep(5000L);
        refreshTokenRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken1).buildBodyMessage();
        refreshTokenRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        this.postOAuthClientRequestExpectingStatus(refreshTokenRequest, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode());
        getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken1);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
        getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken2);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
    }
}

