/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.exception.OAuthSystemException;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleRevokeTokenTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PROTECTED_RESOURCE_PATH = "/protected";

    @Override
    protected String doGetConfigFile() {
        return "oauth2-revoke-token-tests-http-config.xml";
    }

    @Override
    protected String buildURL(String path) {
        return this.getProtocol() + "://localhost:" + this.port.getNumber() + path;
    }

    @Test
    public void revokeAccessTokenAndValidate() throws Exception {
        Map<String, Object> tokenResponse = this.performAuthorizationCodeOAuth2DanceAndAccessProtectedResource();
        String accessToken = (String)tokenResponse.get("access_token");
        String refreshToken = (String)tokenResponse.get("refresh_token");
        this.accessProtectedResource(accessToken);
        ((FlowRunner)this.flowRunner("revokeToken").withPayload((Object)accessToken)).run();
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
        this.useInvalidRefreshToken(refreshToken);
    }

    @Test
    public void revokeRefreshTokenAndValidate() throws Exception {
        Map<String, Object> tokenResponse = this.performAuthorizationCodeOAuth2DanceAndAccessProtectedResource();
        String accessToken = (String)tokenResponse.get("access_token");
        String refreshToken = (String)tokenResponse.get("refresh_token");
        ((FlowRunner)this.flowRunner("revokeToken").withPayload((Object)refreshToken)).run();
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
        this.useInvalidRefreshToken(refreshToken);
    }

    private void useInvalidRefreshToken(String refreshToken) throws OAuthSystemException, IOException {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.REFRESH_TOKEN).setRefreshToken(refreshToken).buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode());
    }

    private Map<String, Object> performAuthorizationCodeOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), true);
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessProtectedResource(accessToken);
        return tokenResponse;
    }
}

