/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.AllOf;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderModuleScopeTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Override
    protected String doGetConfigFile() {
        return "oauth2-scope-http-config.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.getScopes().add("USER");
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.AUTHORIZATION_CODE);
        this.updateClientInOS();
    }

    @Test
    public void accessLoginPageClientAuthorizeNoScope() throws Exception {
        this.client.getScopes().clear();
        this.updateClientInOS();
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        String location = getAuthorization.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleScopeTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"temporarily_unavailable")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Client configuration error")));
    }

    @Test
    public void accessLoginPageWithoutScopeFailure() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        String location = getAuthorization.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleScopeTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: scope")));
    }

    @Test
    public void accessLoginPageWithUnsupportedScopeFailure() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("GUEST").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        String location = getAuthorization.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleScopeTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
        MatcherAssert.assertThat(urlParameters.get("error_description"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void accessLoginPageWithScopeSuccess() throws Exception {
        String clientName = RandomStringUtils.randomAlphanumeric((int)20);
        this.client.setClientName(clientName);
        this.updateClientInOS();
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("USER").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        this.executeHttpMethodExpectingStatus((HttpMethod)getAuthorization, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getAuthorization.getResponseHeader("Content-Type").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)MediaType.HTML.toRfcString())));
        String responseBody = getAuthorization.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)AllOf.allOf((Matcher)Matchers.containsString((String)"<html>"), (Matcher)Matchers.containsString((String)"<li>USER</li>"), (Matcher)Matchers.containsString((String)clientName), (Matcher)Matchers.containsString((String)"TestScopedProvider")));
        this.assertHasFormFieldContaining(responseBody, "code");
        this.assertHasFormFieldContaining(responseBody, "clientId1");
        this.assertHasFormFieldContaining(responseBody, "http://fake/redirect");
        this.assertHasFormFieldContaining(responseBody, "USER");
    }

    @Test
    public void validateCredentialsMissingScope() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setParameter("client_secret", "clientSecret1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        String location = postCredentials.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleScopeTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_request")));
        MatcherAssert.assertThat((Object)urlParameters.get("error_description").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Missing mandatory parameter: scope")));
    }

    @Test
    public void validateCredentialsUnsupportedScope() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setScope("GUEST").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        String location = postCredentials.getResponseHeader("Location").getValue();
        MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleScopeTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"invalid_scope")));
        MatcherAssert.assertThat(urlParameters.get("error_description"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void validateCredentialsSuccess() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setScope("USER").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
    }

    @Test
    public void tokenExchangeSuccess() throws Exception {
        this.authorizationCodeStoreHolder.getAuthorizationRequest().getScopes().add("USER");
        this.updateAuthorizationCodeInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        this.validateSuccessfulTokenResponseNoRefresh(this.getContentAsMap((HttpMethod)postToken), "USER");
    }

    @Test
    public void accessScopelessProtectedResourceSuccess() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        this.accessScopelessProtectedResource(accessToken);
    }

    @Test
    public void accessScopedProtectedResourceWithBadScope() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(accessToken);
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected/scopes") + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }

    @Test
    public void accessScopedProtectedResourceSuccess() throws Exception {
        String accessToken = RandomStringUtils.randomAlphanumeric((int)20);
        AccessTokenStoreHolder accessTokenStoreHolder = this.addAccessTokenToStore(accessToken);
        accessTokenStoreHolder.getAccessToken().getScopes().add("USER");
        this.updateAccessTokenHolderInOS(accessTokenStoreHolder);
        this.accessScopedProtectedResource(accessToken);
    }

    @Test
    public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResources() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setScope("USER").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> authorizationResponse = this.validateSuccessfulLoginResponse((HttpMethod)postCredentials, "code");
        String authorizationCode = authorizationResponse.get("code").get(0);
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode(authorizationCode).setClientId("clientId1").setClientSecret("clientSecret1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoRefresh(this.getContentAsMap((HttpMethod)postToken), "USER");
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessScopelessProtectedResource(accessToken);
        this.accessScopedProtectedResource(accessToken);
        this.accessForbiddenScopedProtectedResource(accessToken);
    }

    @Test
    public void performImplicitGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("token").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").setScope("USER").buildBodyMessage();
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> tokenResponse = this.validateSuccessfulLoginResponse((HttpMethod)postToken, "access_token");
        String accessToken = tokenResponse.get("access_token").get(0);
        this.accessScopelessProtectedResource(accessToken);
        this.accessScopedProtectedResource(accessToken);
        this.accessForbiddenScopedProtectedResource(accessToken);
    }

    @Test
    public void performResourceOwnerPasswordCredentialsGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.PASSWORD);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.PASSWORD).setParameter("username", "rousr").setParameter("password", "ropwd+%").setScope("USER").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoRefresh(this.getContentAsMap((HttpMethod)postToken), "USER");
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessScopelessProtectedResource(accessToken);
        this.accessScopedProtectedResource(accessToken);
        this.accessForbiddenScopedProtectedResource(accessToken);
    }

    @Test
    public void performClientCredentialsGrantOAuth2DanceAndAccessProtectedResource() throws Exception {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials").setScope("USER").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> tokenResponse = this.validateSuccessfulTokenResponseNoRefresh(this.getContentAsMap((HttpMethod)postToken), "USER");
        String accessToken = (String)tokenResponse.get("access_token");
        this.accessScopelessProtectedResource(accessToken);
        this.accessScopedProtectedResource(accessToken);
        this.accessForbiddenScopedProtectedResource(accessToken);
    }

    private void accessScopelessProtectedResource(String accessToken) throws IOException {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected/no-scope") + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
    }

    private void accessScopedProtectedResource(String accessToken) throws IOException {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected/scopes") + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseBodyAsString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"accessing::protected_resource")));
    }

    private void accessForbiddenScopedProtectedResource(String accessToken) throws IOException {
        GetMethod getProtectedResource = new GetMethod(this.getProtectedResourceURL("/protected/forbidden-scope") + "?access_token=" + accessToken);
        this.executeHttpMethodExpectingStatus((HttpMethod)getProtectedResource, HttpConstants.HttpStatus.FORBIDDEN.getStatusCode());
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)getProtectedResource.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Bearer realm=\"OAuth2 Client Realm\"")));
    }
}

