/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ObjectStoreClientStore;
import com.mulesoft.modules.oauth2.provider.api.code.ObjectStoreAuthorizationCode;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import net.smartam.leeloo.common.message.types.GrantType;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.http.api.HttpConstants;

public class PrivateObjectStoreTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private static final String PRIVATE_CLIENT_STORE_OBJECT_STORE = "clientsPrivateObjectStore";
    private static final String PRIVATE_TOKENS_STORE_OBJECT_STORE = "tokensPrivateObjectStore";
    private static final String PRIVATE_AUTHORIZATION_CODE_STORE_OBJECT_STORE = "authorizationPrivateObjectStore";
    @Inject
    private ObjectStoreManager objectStoreManager;

    @Before
    public void initializeStores() throws Exception {
        ObjectStore privateClientObjectStore = this.objectStoreManager.getObjectStore(PRIVATE_CLIENT_STORE_OBJECT_STORE);
        ((ObjectStoreClientStore)this.clientStore).setObjectStore(privateClientObjectStore);
        this.initializeClientObjectStore();
        ObjectStore privateAuthorizationObjectStore = this.objectStoreManager.getObjectStore(PRIVATE_AUTHORIZATION_CODE_STORE_OBJECT_STORE);
        ((ObjectStoreAuthorizationCode)this.authorizationCodeStore).setObjectStore(privateAuthorizationObjectStore);
        this.initializeAuthorizationCodeObjectStore();
    }

    @Override
    protected String doGetConfigFile() {
        return "oauth2-private-objectstore-client-store-config.xml";
    }

    @Test
    public void checkPrivateObjectStoreForTokenIsWorking() throws Exception {
        OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setGrantType(GrantType.AUTHORIZATION_CODE).setCode("__valid__").setClientId("clientId1").setRedirectURI("http://fake/redirect").buildBodyMessage();
        oAuthClientRequest.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        PostMethod postToken = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, HttpConstants.HttpStatus.OK.getStatusCode());
        Map<String, Object> parameters = this.validateSuccessfulTokenResponseNoScope(this.getContentAsMap((HttpMethod)postToken), false);
        String accessToken = (String)parameters.get("access_token");
        ObjectStore tokenStore = this.objectStoreManager.getObjectStore(PRIVATE_TOKENS_STORE_OBJECT_STORE);
        Map tokens = tokenStore.retrieveAll();
        this.assertTokenInStore(tokens, accessToken);
    }

    private void assertTokenInStore(Map<String, AccessTokenStoreHolder> tokens, String expectedToken) throws Exception {
        for (Map.Entry<String, AccessTokenStoreHolder> entry : tokens.entrySet()) {
            if (!entry.getValue().getAccessToken().getAccessToken().equals(expectedToken)) continue;
            return;
        }
        Assert.fail((String)String.format("%s not in saved tokens", expectedToken));
    }

    @Test
    public void checkPrivateObjectStoreForClientStoreIsWorking() throws Exception {
        String flowName = "registerClient";
        this.flowRunner("registerClient").run();
        ObjectStore privateClientObjectStore = this.objectStoreManager.getObjectStore(PRIVATE_CLIENT_STORE_OBJECT_STORE);
        Map clients = privateClientObjectStore.retrieveAll();
        this.assertClientIdInStore(clients, "TheClientId");
    }

    private void assertClientIdInStore(Map<String, Client> clients, String expectedId) throws Exception {
        for (Map.Entry<String, Client> entry : clients.entrySet()) {
            if (!entry.getValue().getClientId().equals(expectedId)) continue;
            return;
        }
        Assert.fail((String)String.format("%s not in saved clients", expectedId));
    }

    @Test
    public void checkPrivateObjectStoreForAuthorizationCodeIsWorking() throws Exception {
        OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setParameter("username", "rousr").setParameter("password", "ropwd+%").buildBodyMessage();
        PostMethod postCredentials = this.postOAuthClientRequestExpectingStatus(authorizationRequest, HttpConstants.HttpStatus.MOVED_TEMPORARILY.getStatusCode());
        Map<String, List<String>> responseQueryParams = PrivateObjectStoreTestCase.decodeParameters(postCredentials.getResponseHeader("Location").toString());
        String code = responseQueryParams.get("code").get(0).trim();
        MatcherAssert.assertThat((Object)this.authorizationCodeStore.retrieve(code), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)IsNull.nullValue())));
    }
}

