/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.core.api.util.Base64;

public class UtilsTestCase {
    @Test
    public void generateUniqueId() {
        MatcherAssert.assertThat((Object)Utils.generateUniqueId((String)"salty"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void extractCredentialsFromAuthorizationHeader() throws Exception {
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader(null, (String)"Bar", (String)"utf-8"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader((String)"", (String)"Bar", (String)"utf-8"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader((String)"Foo", (String)"Bar", (String)"utf-8"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader((String)"Foo Ignored", (String)"Bar", (String)"utf-8"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        String credentials = "credentials";
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader((String)("Basic " + Base64.encodeBytes((byte[])"credentials".getBytes())), (String)"Basic", (String)"utf-8"), (Matcher)CoreMatchers.is((Object)"credentials"));
        MatcherAssert.assertThat((Object)Utils.extractCredentialsFromAuthorizationHeader((String)"Bearer credentials", (String)"Bearer", (String)"utf-8"), (Matcher)CoreMatchers.is((Object)"credentials"));
    }

    @Test
    public void tokenizeScope() {
        MatcherAssert.assertThat((Object)Utils.tokenize(null), (Matcher)CoreMatchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)Utils.tokenize((String)""), (Matcher)CoreMatchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)Utils.tokenize((String)" SCOPE1 "), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"SCOPE1"}));
        MatcherAssert.assertThat((Object)Utils.tokenize((String)" SCOPE1  SCOPE2  "), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"SCOPE1", "SCOPE2"}));
        MatcherAssert.assertThat((Object)Utils.tokenize((String)" SCOPE1,SCOPE2  ", (String)","), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"SCOPE1", "SCOPE2"}));
        MatcherAssert.assertThat((Object)Utils.tokenize((String)" SCOPE1, SCOPE2  ", (String)","), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"SCOPE1", "SCOPE2"}));
    }

    @Test
    public void stringifyScopes() {
        MatcherAssert.assertThat((Object)Utils.stringifyScopes(null), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)Utils.stringifyScopes(Collections.emptySet()), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)Utils.stringifyScopes(new HashSet<String>(Arrays.asList("SCOPE1"))), (Matcher)CoreMatchers.is((Object)"SCOPE1"));
        MatcherAssert.assertThat((Object)Utils.stringifyScopes(new HashSet<String>(Arrays.asList("SCOPE1", "SCOPE2"))), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"SCOPE1 SCOPE2"), (Matcher)CoreMatchers.is((Object)"SCOPE2 SCOPE1")));
    }

    @Test(expected=RequestProcessingException.class)
    public void computeEffectiveScopeMissingRequestedScope() throws RequestProcessingException {
        Utils.computeEffectiveScopeOrFail(Collections.emptySet(), (Set)Utils.tokenize((String)"SCOPE1"), (Set)Utils.tokenize((String)"SCOPE1 SCOPE2"));
    }

    @Test(expected=RequestProcessingException.class)
    public void computeEffectiveScopeUnsupportedRequestedScope() throws RequestProcessingException {
        Utils.computeEffectiveScopeOrFail((Set)Utils.tokenize((String)"SCOPE3"), (Set)Utils.tokenize((String)"SCOPE1"), (Set)Utils.tokenize((String)"SCOPE1 SCOPE2"));
    }

    @Test(expected=RequestProcessingException.class)
    public void computeEffectiveScopeObsoleteClientScopes() throws RequestProcessingException {
        Utils.computeEffectiveScopeOrFail((Set)Utils.tokenize((String)"SCOPE1"), (Set)Utils.tokenize((String)"SCOPE3"), (Set)Utils.tokenize((String)"SCOPE1 SCOPE2"));
    }

    @Test
    public void computeEffectiveScope() throws RequestProcessingException {
        MatcherAssert.assertThat((Object)Utils.computeEffectiveScopeOrFail((Set)Utils.tokenize((String)"SCOPE2"), (Set)Utils.tokenize((String)"SCOPE2 SCOPE3"), (Set)Utils.tokenize((String)"SCOPE1 SCOPE2")), (Matcher)CoreMatchers.is(new HashSet<String>(Collections.singletonList("SCOPE2"))));
    }

    @Test
    public void urlDecode() {
        MatcherAssert.assertThat((Object)Utils.urlDecode((String)"a%20b"), (Matcher)CoreMatchers.is((Object)"a b"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void parseProviderGrantTypesFailure() {
        Utils.parseProviderGrantTypes((String)"AUTHORIZATION_CODE ABC");
    }

    @Test
    public void parseProviderGrantTypes() {
        MatcherAssert.assertThat((Object)Utils.parseProviderGrantTypes(null), (Matcher)CoreMatchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)Utils.parseProviderGrantTypes((String)"  "), (Matcher)CoreMatchers.is(Collections.emptySet()));
        MatcherAssert.assertThat((Object)Utils.parseProviderGrantTypes((String)"AUTHORIZATION_CODE, IMPLICIT"), (Matcher)CoreMatchers.is(new HashSet<Constants.ProviderGrantType>(Arrays.asList(Constants.ProviderGrantType.AUTHORIZATION_CODE, Constants.ProviderGrantType.IMPLICIT))));
    }
}

