/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.client;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ClientTestCase {
    private static final String TEST_REDIRECT_URI_WITH_BAD_REGEX = "http://test.redirect.com/[boo";
    private static final String TEST_HTTP_REDIRECT_URI = "http://test.redirect.com/path";
    private static final String TEST_HTTPS_REDIRECT_URI = "https://redirect.com";
    private Client client;

    @Before
    public void initialize() {
        this.client = new Client("test_client_id", null, null, null, null, null);
    }

    @Test
    public void isValidRedirectUriEquality() {
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)false));
        this.client.getRedirectUris().add("http://other.com");
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)false));
        this.client.getRedirectUris().add(TEST_HTTP_REDIRECT_URI);
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)true));
        this.client.getRedirectUris().add(TEST_REDIRECT_URI_WITH_BAD_REGEX);
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_REDIRECT_URI_WITH_BAD_REGEX), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isValidRedirectUriStarPattern() {
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)false));
        this.client.getRedirectUris().add("http://*.redirect.com/*");
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTPS_REDIRECT_URI), (Matcher)Matchers.is((Object)false));
        this.client.getRedirectUris().add("*redirect.com*");
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.client.isValidRedirectUri(TEST_HTTPS_REDIRECT_URI), (Matcher)Matchers.is((Object)true));
    }
}

