/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.error;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import java.util.Collections;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.PostMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class OAuth2ProviderClientCredentialsErrorsTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Override
    protected String doGetConfigFile() {
        return "client-credentials-errors-config.xml";
    }

    @Before
    public void setupClient() {
        this.client.getAuthorizedGrantTypes().add(Constants.RequestGrantType.CLIENT_CREDENTIALS);
        this.updateClientInOS();
    }

    private OAuthClientRequest.TokenRequestBuilder baseRequest() {
        return OAuthClientRequest.tokenLocation((String)this.getTokenEndpointURL()).setParameter("grant_type", "client_credentials");
    }

    private void assertErrorInRequest(OAuthClientRequest oAuthClientRequest, String expectedError, String expectedDescription, int expectedErrorCode) throws Exception {
        PostMethod response = this.postOAuthClientRequestExpectingStatus(oAuthClientRequest, expectedErrorCode);
        MatcherAssert.assertThat((Object)response.getResponseBodyAsString(), (Matcher)Matchers.containsString((String)("\"error\":\"" + expectedError)));
        MatcherAssert.assertThat((Object)response.getResponseBodyAsString(), (Matcher)Matchers.containsString((String)("\"error_description\":\"" + expectedDescription)));
    }

    private void assertErrorInRequest(OAuthClientRequest oAuthClientRequest, String expectedError, String expectedDescription) throws Exception {
        this.assertErrorInRequest(oAuthClientRequest, expectedError, expectedDescription, 400);
    }

    private void assertInvalidRequest(OAuthClientRequest oAuthClientRequest, String expectedDescription) throws Exception {
        this.assertErrorInRequest(oAuthClientRequest, "invalid_request", expectedDescription);
    }

    private void assertInvalidClient(OAuthClientRequest oAuthClientRequest, String expectedDescription) throws Exception {
        this.assertErrorInRequest(oAuthClientRequest, "invalid_client", expectedDescription);
    }

    @Test
    public void missingAuthentication() throws Exception {
        this.assertInvalidClient(this.baseRequest().buildBodyMessage(), "No client identification nor authentication found");
    }

    @Test
    public void multipleAuthenticationMethods() throws Exception {
        OAuthClientRequest request = this.baseRequest().setClientId("clientId1").setClientSecret("clientSecret1").buildBodyMessage();
        request.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "clpwd+%")));
        this.assertInvalidRequest(request, "Multiple client authentications found");
    }

    @Test
    public void unregisteredClientIdWithSecret() throws Exception {
        OAuthClientRequest request = this.baseRequest().setClientId("unregisteredClient").setClientSecret("clientSecret1").buildBodyMessage();
        this.assertInvalidClient(request, "Invalid credentials");
    }

    @Test
    public void unregisteredClientIdInAuthenticationHeader() throws Exception {
        OAuthClientRequest request = this.baseRequest().buildBodyMessage();
        request.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("unregisteredClientId", "clpwd+%")));
        this.assertErrorInRequest(request, "invalid_client", "Invalid credentials", 401);
    }

    @Test
    public void unauthorizedClientWithSecret() throws Exception {
        this.assertInvalidClient(this.baseRequest().setClientId("clientId1").setClientSecret("wrongSecret").buildBodyMessage(), "Invalid credentials");
    }

    @Test
    public void unauthorizedClientWithAuthorizationHeader() throws Exception {
        OAuthClientRequest request = this.baseRequest().buildBodyMessage();
        request.setHeaders(Collections.singletonMap("Authorization", this.getValidBasicAuthHeaderValue("clientId1", "wrongSecret")));
        this.assertErrorInRequest(request, "invalid_client", "Invalid credentials", 401);
    }
}

