/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.error;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import io.qameta.allure.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;

public class OAuth2ProviderErrorsTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
    }

    @Override
    protected String doGetConfigFile() {
        return "provider-errors-config.xml";
    }

    @Description(value="Try to revoke a token that does not exist and see that the correct error is raised")
    @Test
    public void revokeMissingToken() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("revokeMissingToken").withPayload((Object)"MISSING_TOKEN")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"INVALID_TOKEN")));
    }

    @Description(value="Validate an empty token and see that it's invalid")
    @Test
    public void validateTokenEmptyToken() throws Exception {
        CoreEvent event = this.flowRunner("validateTokenEmptyToken").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"UNAUTHORIZED_TOKEN")));
    }

    @Description(value="Validate a token that was never granted by the provider")
    @Test
    public void validateUnexistentToken() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("validateUnexistentToken").withVariable("ACCESS_TOKEN", (Object)RandomStringUtils.randomAlphanumeric((int)20))).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"UNAUTHORIZED_TOKEN")));
    }

    @Description(value="Validate a token with unmatching scopes with the ones registered and see that if fails")
    @Test
    public void validateUnmatchingScopes() throws Exception {
        String token = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(token);
        List<Object> scopes = new ArrayList();
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("validateUnmatchingScopesToken").withVariable("ACCESS_TOKEN", (Object)token)).withVariable("SCOPES", scopes)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"valid scopes"));
        scopes = Collections.singletonList("USER");
        event = ((FlowRunner)((FlowRunner)this.flowRunner("validateUnmatchingScopesToken").withVariable("ACCESS_TOKEN", (Object)token)).withVariable("SCOPES", scopes)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"UNAUTHORIZED_TOKEN")));
    }

    @Description(value="Validate token with unmatching resource owner roles and see that it fails with the expected error")
    @Test
    public void validateUnmatchingRoles() throws Exception {
        String token = RandomStringUtils.randomAlphanumeric((int)20);
        this.addAccessTokenToStore(token);
        List<Object> resourceOwnerRoles = new ArrayList();
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("validateUnmatchingRolesToken").withVariable("ACCESS_TOKEN", (Object)token)).withVariable("ROLES", resourceOwnerRoles)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"valid roles"));
        resourceOwnerRoles = Collections.singletonList("RESOURCE_OWNER");
        event = ((FlowRunner)((FlowRunner)this.flowRunner("validateUnmatchingRolesToken").withVariable("ACCESS_TOKEN", (Object)token)).withVariable("ROLES", resourceOwnerRoles)).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"UNAUTHORIZED_TOKEN")));
    }

    @Description(value="Create client with existent clientId and no override flag and see that it fails with the expected error")
    @Test
    public void createExistentClient() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("createExistentClient").withVariable("CLIENT_ID", (Object)"clientId1")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"CLIENT_ALREADY_EXISTS")));
    }

    @Description(value="Create client with authorizationCode or implicit grant type but no redirection uri")
    @Test
    public void createClientNoRedirectUri() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("createClientNoRedirectionUri").withVariable("GRANT_TYPES", Collections.singletonList(Constants.RequestGrantType.AUTHORIZATION_CODE))).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"INVALID_CONFIGURATION")));
    }

    @Description(value="Create client with invalid grant type and see that it fails with the expected error")
    @Test
    public void createClientWrongGrantType() throws Exception {
        this.expectedException.expectMessage("RequestGrantType");
        this.flowRunner("createClientWrongGrantType").run();
    }

    @Description(value="Create client with no secret whit CONFIDENTIAL type and see that it fails")
    @Test
    public void createConfidentialClientNoSecret() throws Exception {
        CoreEvent event = this.flowRunner("createConfidentialClientNoSecret").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"INVALID_CONFIGURATION")));
    }

    @Description(value="Delete not existent client and see that if fails with the expected exception")
    @Test
    public void deleteNotExistentClient() throws Exception {
        CoreEvent event = this.flowRunner("deleteNotExistentClient").run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"NO_SUCH_CLIENT")));
    }
}

