/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.error;

import com.mulesoft.modules.oauth2.provider.AbstractOAuth2ProviderModuleTestCase;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpHeaders;

public class OAuth2ProviderModuleAuthorizationRequestErrorsTestCase
extends AbstractOAuth2ProviderModuleTestCase {
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;

    @Before
    public void resetRequest() throws Exception {
        this.authenticationRequestBuilder = OAuthClientRequest.authorizationLocation((String)this.getAuthorizationEndpointUrl()).setResponseType("code").setClientId("clientId1").setRedirectURI("http://fake/redirect").setScope("USER").setParameter("username", "rousr").setParameter("password", "ropwd+%");
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client.setScopes(new HashSet<String>(Collections.singletonList("USER")));
        this.updateClientInOS();
    }

    @Override
    protected String doGetConfigFile() {
        return "authorization-errors-config.xml";
    }

    private void assertFailingRequest(HttpMethodBase method, String expectedErrorCode, int statusCode) throws Exception {
        this.executeHttpMethodExpectingStatus((HttpMethod)method, statusCode);
        String responseBody = method.getResponseBodyAsString();
        MatcherAssert.assertThat((Object)responseBody, (Matcher)Matchers.containsString((String)String.format("error=%s", expectedErrorCode)));
    }

    private void assertInvalidRequest(HttpMethodBase method, String expectedErrorCode) throws Exception {
        this.executeHttpMethodExpectingStatus((HttpMethod)method, 302);
        String location = method.getResponseHeader("Location").getValue();
        Map<String, List<String>> urlParameters = OAuth2ProviderModuleAuthorizationRequestErrorsTestCase.decodeParameters(location);
        MatcherAssert.assertThat((Object)urlParameters.get("error").get(0), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)expectedErrorCode)));
    }

    private void assertBadRequest(HttpMethodBase method, String expectedErrorCode) throws Exception {
        this.assertFailingRequest(method, expectedErrorCode, 400);
    }

    @Test
    public void duplicateGrantTypeWithGET() throws Exception {
        this.assertDuplicateParameterWithGET("response_type=some_other_response_type");
    }

    @Test
    public void duplicateClientIdTypeWithGET() throws Exception {
        this.assertDuplicateParameterWithGET("client_id=some_other_client_id");
    }

    @Test
    public void duplicateRedirectUriWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setParameter("redirect_uri", "http://fake/redirect/otherThing").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertBadRequest((HttpMethodBase)getAuthorization, "invalid_redirection_uri");
    }

    @Test
    public void duplicateScopeTypeWithGET() throws Exception {
        this.assertDuplicateParameterWithGET("scope=some_other_scope");
    }

    @Test
    public void missingResponseTypeWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setResponseType(null).buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "unsupported_response_type");
    }

    @Test
    public void missingClientIdWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setClientId(null).buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "invalid_request");
    }

    @Test
    public void invalidRedirectUriWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setRedirectURI("__bad__").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertBadRequest((HttpMethodBase)getAuthorization, "invalid_redirection_uri");
    }

    @Test
    public void unauthorizedClientMissingClientWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setClientId("some_unauthorized_client").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "unauthorized_client");
    }

    @Test
    public void unauthorizedClientWrongScopeWithGET() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setScope("wrong_scope").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "invalid_scope");
    }

    @Test
    public void unsupportedResponseType() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setResponseType("some_unsupported_response_type").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "unsupported_response_type");
    }

    @Test
    public void invalidScope() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setScope("some_invalid_scope").buildQueryMessage();
        GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
        getAuthorization.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)getAuthorization, "invalid_scope");
    }

    @Test
    public void tooManyRequests() throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.setParameter("password", "__bad_password__").buildBodyMessage();
        PostMethod post = this.buildPostMethod(authorizationRequest);
        this.assertInvalidRequest((HttpMethodBase)post, "access_denied");
        this.assertInvalidRequest((HttpMethodBase)post, "access_denied");
        this.executeHttpMethodExpectingStatus((HttpMethod)post, HttpConstants.HttpStatus.TOO_MANY_REQUESTS.getStatusCode());
        this.executeHttpMethodExpectingStatus((HttpMethod)post, HttpConstants.HttpStatus.TOO_MANY_REQUESTS.getStatusCode());
    }

    private void assertDuplicateParameterWithGET(String extraParameter) throws Exception {
        OAuthClientRequest authorizationRequest = this.authenticationRequestBuilder.buildQueryMessage();
        GetMethod get = new GetMethod(authorizationRequest.getLocationUri());
        get.setQueryString(get.getQueryString() + "&" + extraParameter);
        get.setFollowRedirects(false);
        this.assertInvalidRequest((HttpMethodBase)get, "invalid_request");
    }

    private PostMethod buildPostMethod(OAuthClientRequest oAuthClientRequest) throws UnsupportedEncodingException {
        PostMethod postMethod = new PostMethod(oAuthClientRequest.getLocationUri());
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(oAuthClientRequest.getBody(), HttpHeaders.Values.APPLICATION_X_WWW_FORM_URLENCODED.toRfcString(), Charset.defaultCharset().toString()));
        return postMethod;
    }
}

