/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.ratelimit;

import com.mulesoft.modules.oauth2.provider.api.ratelimit.PeriodRateLimiter;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.internal.ratelimit.RateLimitExceededException;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;

public class PeriodRateLimiterTestCase {
    private PeriodRateLimiter rateLimiter;

    @Before
    public void setUp() throws Exception {
        this.rateLimiter = new PeriodRateLimiter();
        this.rateLimiter.setMaximumFailureCount(5);
        this.rateLimiter.setDuration(600, TimeUnit.SECONDS);
    }

    @Test(expected=RateLimitExceededException.class)
    public void rateExceeded() throws RateLimitExceededException {
        for (int i = 0; i < this.getTooManyFailuresCount(); ++i) {
            this.rateLimiter.checkOperationAuthorized(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test");
            this.rateLimiter.recordOperationOutcome(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test", RateLimiter.Outcome.FAILURE);
        }
    }

    @Test
    public void successResetsFailureCount() throws RateLimitExceededException {
        for (int i = 0; i < this.getTooManyFailuresCount(); ++i) {
            this.rateLimiter.checkOperationAuthorized(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test");
            this.rateLimiter.recordOperationOutcome(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test", i % 5 == 0 ? RateLimiter.Outcome.SUCCESS : RateLimiter.Outcome.FAILURE);
        }
    }

    @Test
    public void timeOutResetsFailureCount() throws Exception {
        this.rateLimiter.setDuration(1, TimeUnit.SECONDS);
        for (int i = 0; i < this.getTooManyFailuresCount(); ++i) {
            if (i == this.rateLimiter.getMaximumFailureCount()) {
                Thread.sleep(1100L);
            }
            this.rateLimiter.checkOperationAuthorized(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test");
            this.rateLimiter.recordOperationOutcome(RateLimiter.Operation.RESOURCE_OWNER_LOGIN, "test", RateLimiter.Outcome.FAILURE);
        }
    }

    private int getTooManyFailuresCount() {
        return this.rateLimiter.getMaximumFailureCount() + 1;
    }
}

