/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.security.AbstractSecurityProvider;

public class CustomSecurityProvider extends AbstractSecurityProvider {

  private static final String TEST_RESOURCE_OWNER_USERNAME = "rousr";
  private static final String TEST_RESOURCE_OWNER_PASSWORD = "ropwd+%";
  private static final String TEST_CLIENT_OPTIONAL_PRINCIPAL = "clusr";
  private static final String TEST_CLIENT_PASSWORD = "clpwd+%";

  public CustomSecurityProvider() {
    this("CustomSecurityProvider");
  }

  public CustomSecurityProvider(String name) {
    super(name);
  }

  @Override
  public Authentication authenticate(Authentication authentication) throws SecurityException {
    if ((authentication.getPrincipal().equals(TEST_RESOURCE_OWNER_USERNAME)
        && authentication.getCredentials().equals(TEST_RESOURCE_OWNER_PASSWORD)) ||
        (authentication.getPrincipal().equals(TEST_CLIENT_OPTIONAL_PRINCIPAL)
            && authentication.getCredentials().equals(TEST_CLIENT_PASSWORD))) {
      return authentication;
    }
    throw new SecurityException(createStaticMessage("Authentication exception"));
  }
}
