/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;


import static net.smartam.leeloo.common.message.types.GrantType.AUTHORIZATION_CODE;
import static org.apache.http.HttpStatus.SC_MOVED_TEMPORARILY;
import static org.apache.http.HttpStatus.SC_OK;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasEntry;

import com.mulesoft.modules.oauth2.provider.api.token.generator.TokenGeneratorStrategy;

import java.util.List;
import java.util.Map;

import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Test;

public class CustomTokenGeneratorStrategyTestCase extends AbstractOAuth2ProviderModuleTestCase {

  @Override
  protected String doGetConfigFile() {
    return "oauth2-custom-token-generator-strategy-config.xml";
  }

  @Test
  public void customTokenGeneratorStrategyIsUsed() throws Exception {
    final OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation(
                                                                                             getAuthorizationEndpointUrl())
        .setResponseType("code")
        .setClientId(TEST_CLIENT_ID)
        .setRedirectURI(TEST_REDIRECT_URI)
        .setParameter("username", TEST_RESOURCE_OWNER_USERNAME)
        .setParameter("password", TEST_RESOURCE_OWNER_PASSWORD)
        .buildBodyMessage();

    final PostMethod postCredentials = postOAuthClientRequestExpectingStatus(authorizationRequest,
                                                                             SC_MOVED_TEMPORARILY);

    final Map<String, List<String>> authorizationResponse = validateSuccessfulLoginResponse(
                                                                                            postCredentials, "code");
    final String authorizationCode = authorizationResponse.get("code").get(0);

    final OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation(getTokenEndpointURL())
        .setGrantType(AUTHORIZATION_CODE)
        .setClientId(TEST_CLIENT_ID)
        .setClientSecret(TEST_CLIENT_SECRET)
        .setCode(authorizationCode)
        .setRedirectURI(TEST_REDIRECT_URI)
        .buildBodyMessage();


    final PostMethod postToken = postOAuthClientRequestExpectingStatus(oAuthClientRequest,
                                                                       SC_OK);
    assertThat(getContentAsMap(postToken), hasEntry("access_token", CustomTokenGeneratorStrategy.TOKEN));
  }

  public static class CustomTokenGeneratorStrategy implements TokenGeneratorStrategy {

    public static final String TOKEN = "SINGLE_TOKEN";

    @Override
    public String generateToken() {
      return TOKEN;
    }
  }


}
