/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;


import static com.mulesoft.modules.oauth2.provider.api.Constants.RequestGrantType.AUTHORIZATION_CODE;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;

import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Test;

public class OAuth2ProviderCustomLoginPageTestCase extends AbstractOAuth2ProviderModuleTestCase {

  @Override
  protected String doGetConfigFile() {
    return "oauth2-custom-login-page-config.xml";
  }

  @Override
  protected void doSetUp() throws Exception {
    super.doSetUp();
    client.getScopes().add(USER_SCOPE);
    client.getAuthorizedGrantTypes().add(AUTHORIZATION_CODE);
    updateClientInOS();
  }

  @Test
  public void accessDefaultLoginPageWithScopeSuccess() throws Exception {
    final String clientName = RandomStringUtils.randomAlphanumeric(20);
    client.setClientName(clientName);
    updateClientInOS();

    final OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation(
                                                                                             getAuthorizationEndpointUrl())
        .setResponseType("code")
        .setClientId(TEST_CLIENT_ID)
        .setRedirectURI(TEST_REDIRECT_URI)
        .setScope(USER_SCOPE)
        .buildQueryMessage();

    final GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
    executeHttpMethodExpectingStatus(getAuthorization, OK.getStatusCode());
    final String responseBody = getAuthorization.getResponseBodyAsString();
    assertThat(responseBody, containsString("@font-face"));
  }

}
