/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;

import static net.smartam.leeloo.common.message.types.GrantType.AUTHORIZATION_CODE;
import static org.apache.http.HttpStatus.SC_MOVED_TEMPORARILY;
import static org.apache.http.HttpStatus.SC_OK;
import static org.junit.rules.ExpectedException.none;

import com.mulesoft.modules.oauth2.provider.internal.config.IllegalConfigurationException;

import java.util.List;
import java.util.Map;

import io.qameta.allure.Description;
import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OAuth2ProviderModuleNoClientSecurityProviderSuccessTestCase extends AbstractOAuth2ProviderModuleTestCase {

  @Rule
  public ExpectedException expectedException = none();

  @Override
  protected String doGetConfigFile() {
    return "oauth2-no-client-security-provider-success.xml";
  }

  @Test
  @Description("Check that the provider works ok if there is only PUBLIC clients")
  public void provideWorksOkWithOnlyPublicClients() throws Exception {
    getTokenAndValidate("publicClientId", "", "/publicAuthorize", "/publicToken", "/protectedPublic");
  }

  @Test
  @Description("Check that the provider works ok if there is only CONFIDENTIAL clients with secrets")
  public void provideWorksOkWithConfidentialClientsAndSecret() throws Exception {
    getTokenAndValidate("confidentialClientId", "confidentialClientSecret", "/confidentialAuthorize", "/confidentialToken",
                        "/protectedConfidential");
  }

  private void getTokenAndValidate(String clientID, String clientSecret, String authorizationEndpoint, String tokenEndpoint,
                                   String validationEndpoint)
      throws Exception {
    final OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation(
                                                                                             buildURL(authorizationEndpoint))
        .setResponseType("code")
        .setClientId(clientID)
        .setRedirectURI(TEST_REDIRECT_URI)
        .setParameter("username", TEST_RESOURCE_OWNER_USERNAME)
        .setParameter("password", TEST_RESOURCE_OWNER_PASSWORD)
        .buildBodyMessage();

    final PostMethod postCredentials = postOAuthClientRequestExpectingStatus(authorizationRequest, SC_MOVED_TEMPORARILY);

    final Map<String, List<String>> authorizationResponse = validateSuccessfulLoginResponse(postCredentials, "code");
    final String authorizationCode = authorizationResponse.get("code").get(0);

    final OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation(buildURL(tokenEndpoint))
        .setGrantType(AUTHORIZATION_CODE)
        .setCode(authorizationCode)
        .setClientId(clientID)
        .setClientSecret(clientSecret)
        .setRedirectURI(TEST_REDIRECT_URI)
        .buildBodyMessage();

    final PostMethod postToken = postOAuthClientRequestExpectingStatus(oAuthClientRequest, SC_OK);

    final Map<String, Object> tokenResponse = validateSuccessfulTokenResponseNoScopeNoRefresh(getContentAsMap(postToken));
    final String accessToken = (String) tokenResponse.get("access_token");
    accessProtectedResource(accessToken, validationEndpoint);
  }



}
