/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;


import static net.smartam.leeloo.common.message.types.GrantType.AUTHORIZATION_CODE;
import static org.apache.http.HttpStatus.SC_MOVED_TEMPORARILY;
import static org.apache.http.HttpStatus.SC_OK;
import static org.apache.http.HttpStatus.SC_UNAUTHORIZED;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;

import java.util.List;
import java.util.Map;

import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.junit.Test;

public class DifferentTokenSecurityProvidersTestCase extends AbstractOAuth2ProviderModuleTestCase {

  private static final String PROTECTED_RESOURCE_PATH = "/protected";
  private static final String PROTECTED_RESOURCE_PATH_2 = "/protected2";

  @Override
  protected String doGetConfigFile() {
    return "oauth2-different-token-security-provider-config.xml";
  }

  @Test
  public void TokenGrantedByOneProviderDoesNotWorkWithOther() throws Exception {
    final OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation(
                                                                                             getAuthorizationEndpointUrl())
        .setResponseType("code")
        .setClientId(TEST_CLIENT_ID)
        .setRedirectURI(TEST_REDIRECT_URI)
        .setParameter("username", TEST_RESOURCE_OWNER_USERNAME)
        .setParameter("password", TEST_RESOURCE_OWNER_PASSWORD)
        .buildBodyMessage();

    final PostMethod postCredentials = postOAuthClientRequestExpectingStatus(authorizationRequest, SC_MOVED_TEMPORARILY);

    final Map<String, List<String>> authorizationResponse = validateSuccessfulLoginResponse(postCredentials, "code");
    final String authorizationCode = authorizationResponse.get("code").get(0);

    final OAuthClientRequest oAuthClientRequest = OAuthClientRequest.tokenLocation(getTokenEndpointURL())
        .setGrantType(AUTHORIZATION_CODE)
        .setCode(authorizationCode)
        .setClientId(TEST_CLIENT_ID)
        .setClientSecret(TEST_CLIENT_SECRET)
        .setRedirectURI(TEST_REDIRECT_URI)
        .buildBodyMessage();

    final PostMethod postToken = postOAuthClientRequestExpectingStatus(oAuthClientRequest, SC_OK);

    final Map<String, Object> tokenResponse = validateSuccessfulTokenResponseNoScopeNoRefresh(getContentAsMap(postToken));
    final String accessToken = (String) tokenResponse.get("access_token");

    //Check that the token is valid for provider 1
    GetMethod getProtectedResource =
        new GetMethod(getProtectedResourceURL(PROTECTED_RESOURCE_PATH) + "?access_token=" + accessToken);
    executeHttpMethodExpectingStatus(getProtectedResource, SC_OK);
    assertThat(getProtectedResource.getResponseBodyAsString(), is(equalTo(PROTECTED_RESOURCE_CONTENT)));

    //But is not valid for provider 2
    getProtectedResource = new GetMethod(getProtectedResourceURL(PROTECTED_RESOURCE_PATH_2) + "?access_token=" + accessToken);
    executeHttpMethodExpectingStatus(getProtectedResource, SC_UNAUTHORIZED);
    assertThat(getProtectedResource.getResponseBodyAsString(), is(equalTo(("token not in security provider"))));

  }
}
