/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;

import static com.mulesoft.modules.oauth2.provider.api.Constants.RequestGrantType.AUTHORIZATION_CODE;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.core.AllOf.allOf;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;
import static org.mule.runtime.http.api.HttpHeaders.Names.CONTENT_TYPE;
import static org.mule.runtime.api.metadata.MediaType.HTML;

import net.smartam.leeloo.client.request.OAuthClientRequest;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.RandomStringUtils;

import org.junit.Test;

public class OAuth2ProviderModuleDefaultLoginPageTestCase extends AbstractOAuth2ProviderModuleTestCase {

  @Override
  protected String doGetConfigFile() {
    return "oauth2-default-login-page-config.xml";
  }

  @Override
  protected void doSetUp() throws Exception {
    super.doSetUp();
    client.getScopes().add(USER_SCOPE);
    client.getAuthorizedGrantTypes().add(AUTHORIZATION_CODE);
    updateClientInOS();
  }

  @Test
  public void accessDefaultLoginPageWithScopeSuccess() throws Exception {
    final String clientName = RandomStringUtils.randomAlphanumeric(20);
    client.setClientName(clientName);
    updateClientInOS();

    final OAuthClientRequest authorizationRequest = OAuthClientRequest.authorizationLocation(
                                                                                             getAuthorizationEndpointUrl())
        .setResponseType("code")
        .setClientId(TEST_CLIENT_ID)
        .setRedirectURI(TEST_REDIRECT_URI)
        .setScope(USER_SCOPE)
        .buildQueryMessage();

    final GetMethod getAuthorization = new GetMethod(authorizationRequest.getLocationUri());
    executeHttpMethodExpectingStatus(getAuthorization, OK.getStatusCode());

    assertThat(getAuthorization.getResponseHeader(CONTENT_TYPE).getValue(), is(equalTo(HTML.toRfcString())));

    final String responseBody = getAuthorization.getResponseBodyAsString();
    assertThat(responseBody, allOf(
                                   containsString("<html>"),
                                   containsString("<li>" + USER_SCOPE + "</li>"),
                                   containsString(clientName),
                                   containsString("Popular Social Network")));
    assertHasFormFieldContaining(responseBody, "code");
    assertHasFormFieldContaining(responseBody, TEST_CLIENT_ID);
    assertHasFormFieldContaining(responseBody, TEST_REDIRECT_URI);
    assertHasFormFieldContaining(responseBody, USER_SCOPE);
  }

}
