/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;

import static com.mulesoft.modules.oauth2.provider.api.Constants.RequestGrantType.AUTHORIZATION_CODE;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.is;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.FORBIDDEN;

import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Test;

public class OAuth2ProviderModuleInvalidAccessTokenExceptionFlowTestCase extends AbstractOAuth2ProviderModuleTestCase {

  private static final String INVALID_ACCESS_TOKEN = "invalid";

  @Override
  protected String doGetConfigFile() {
    return "oauth2-invalid-exception-flow-http-config.xml";
  }

  @Override
  protected void doSetUp() throws Exception {
    super.doSetUp();
    client.getScopes().add(USER_SCOPE);

    client.getAuthorizedGrantTypes().add(AUTHORIZATION_CODE);
    updateClientInOS();
  }


  @Test
  public void performAuthorizationCodeOAuth2DanceAndAccessProtectedResources() throws Exception {
    final GetMethod getProtectedResource = new GetMethod(getProtectedResourceURL("/protected/preFlow")
        + "?access_token=" + INVALID_ACCESS_TOKEN);
    executeHttpMethodExpectingStatus(getProtectedResource, FORBIDDEN.getStatusCode());
    assertThat(getProtectedResource.getResponseBodyAsString(), is(equalTo(("invalid_access"))));
  }

}
