/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider;

import static org.junit.rules.ExpectedException.none;
import org.mule.runtime.api.lifecycle.InitialisationException;

import io.qameta.allure.Description;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OAuth2ProviderModuleNoClientSecurityProviderFailureTestCase extends AbstractOAuth2ProviderModuleTestCase {

  @Rule
  public ExpectedException expectedException = none();

  public OAuth2ProviderModuleNoClientSecurityProviderFailureTestCase() {
    expectedException.expect(InitialisationException.class);
    expectedException.expectMessage("A Client Security Provided should be configured");
  }

  @Override
  protected String doGetConfigFile() {
    return "oauth2-no-client-security-provider-failure-confidential-no-secret.xml";
  }

  @Test
  @Description("Client security provider must be configured if there are CONFIDENTIAL clients with no secret")
  public void noCSecurityProviderFailsIfCCWithNoSecret() {
    //Validation is actually done in constructor
  }

}
