/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.client;


import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.modules.oauth2.provider.api.client.Client;

import org.junit.Before;
import org.junit.Test;

public class ClientTestCase {

  private static final String TEST_REDIRECT_URI_WITH_BAD_REGEX = "http://test.redirect.com/[boo";
  private static final String TEST_HTTP_REDIRECT_URI = "http://test.redirect.com/path";
  private static final String TEST_HTTPS_REDIRECT_URI = "https://redirect.com";

  private Client client;

  @Before
  public void initialize() {
    client = new Client("test_client_id", null, null, null, null, null);
  }

  @Test
  public void isValidRedirectUriEquality() {
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(false));

    client.getRedirectUris().add("http://other.com");
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(false));

    client.getRedirectUris().add(TEST_HTTP_REDIRECT_URI);
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(true));

    client.getRedirectUris().add(TEST_REDIRECT_URI_WITH_BAD_REGEX);
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(true));
    assertThat(client.isValidRedirectUri(TEST_REDIRECT_URI_WITH_BAD_REGEX), is(true));
  }

  @Test
  public void isValidRedirectUriStarPattern() {
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(false));

    client.getRedirectUris().add("http://*.redirect.com/*");
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(true));
    assertThat(client.isValidRedirectUri(TEST_HTTPS_REDIRECT_URI), is(false));

    client.getRedirectUris().add("*redirect.com*");
    assertThat(client.isValidRedirectUri(TEST_HTTP_REDIRECT_URI), is(true));
    assertThat(client.isValidRedirectUri(TEST_HTTPS_REDIRECT_URI), is(true));
  }
}
