/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.ratelimit;

import static com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter.Operation.RESOURCE_OWNER_LOGIN;
import static com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter.Outcome.FAILURE;
import static com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter.Outcome.SUCCESS;
import static java.util.concurrent.TimeUnit.SECONDS;

import com.mulesoft.modules.oauth2.provider.api.ratelimit.PeriodRateLimiter;
import com.mulesoft.modules.oauth2.provider.internal.ratelimit.RateLimitExceededException;

import org.junit.Before;
import org.junit.Test;

public class PeriodRateLimiterTestCase {

  private PeriodRateLimiter rateLimiter;

  @Before
  public void setUp() throws Exception {
    rateLimiter = new PeriodRateLimiter();
    rateLimiter.setMaximumFailureCount(5);
    rateLimiter.setDuration(600, SECONDS);
  }

  @Test(expected = RateLimitExceededException.class)
  public void rateExceeded() throws RateLimitExceededException {
    for (int i = 0; i < getTooManyFailuresCount(); i++) {
      rateLimiter.checkOperationAuthorized(RESOURCE_OWNER_LOGIN, "test");
      rateLimiter.recordOperationOutcome(RESOURCE_OWNER_LOGIN, "test", FAILURE);
    }
  }

  @Test
  public void successResetsFailureCount() throws RateLimitExceededException {
    for (int i = 0; i < getTooManyFailuresCount(); i++) {
      rateLimiter.checkOperationAuthorized(RESOURCE_OWNER_LOGIN, "test");
      rateLimiter.recordOperationOutcome(RESOURCE_OWNER_LOGIN, "test",
                                         i % 5 == 0 ? SUCCESS : FAILURE);
    }
  }

  @Test
  public void timeOutResetsFailureCount() throws Exception {
    rateLimiter.setDuration(1, SECONDS);

    for (int i = 0; i < getTooManyFailuresCount(); i++) {
      if (i == rateLimiter.getMaximumFailureCount()) {
        Thread.sleep(1100L);
      }

      rateLimiter.checkOperationAuthorized(RESOURCE_OWNER_LOGIN, "test");
      rateLimiter.recordOperationOutcome(RESOURCE_OWNER_LOGIN, "test", FAILURE);
    }
  }

  private int getTooManyFailuresCount() {
    return rateLimiter.getMaximumFailureCount() + 1;
  }

}
