/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.client;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;
import com.mulesoft.modules.oauth2.provider.internal.AbstractObjectStoreBacked;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientRegistration;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;

public class ObjectStoreClientStore
extends AbstractObjectStoreBacked<Client>
implements ClientStore,
ClientRegistration {
    public static final String CLIENTS_PARTITION = "Clients";
    private ObjectStore clientObjectStore;

    @Override
    public Client getClientById(String clientId) throws NoSuchClientException {
        Client client = (Client)this.getFromObjectStore(clientId, this.clientObjectStore);
        if (client == null) {
            throw new NoSuchClientException("Client Id is invalid");
        }
        return client;
    }

    @Override
    public void addClient(Client client, boolean failIfPresent) throws ClientAlreadyExistsException {
        try {
            this.putInObjectStore(client.getClientId(), client, this.clientObjectStore, failIfPresent);
        }
        catch (ObjectAlreadyExistsException e) {
            throw new ClientAlreadyExistsException(String.format("The client with ID: %s is already registered", client.getClientId()));
        }
    }

    @Override
    public void removeClient(String clientId) throws NoSuchClientException {
        Client client = (Client)this.removeFromObjectStore(clientId, this.clientObjectStore);
        if (client == null) {
            throw new NoSuchClientException(String.format("Client with ID %s does not exist", clientId));
        }
    }

    public void setObjectStore(ObjectStore clientObjectStore) {
        this.clientObjectStore = clientObjectStore;
    }

    public ObjectStore getClientObjectStore() {
        return this.clientObjectStore;
    }
}

