/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import com.google.gson.JsonObject;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;
import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2ConfigurationException;
import com.mulesoft.modules.oauth2.provider.api.token.AccessTokenStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.InvalidTokenException;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.api.token.TokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.UnauthorizedTokenException;
import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderSecurityException;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.error.CreateClientErrorProvider;
import com.mulesoft.modules.oauth2.provider.internal.error.DeleteClientErrorProvider;
import com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError;
import com.mulesoft.modules.oauth2.provider.internal.error.RevokeTokenErrorProvider;
import com.mulesoft.modules.oauth2.provider.internal.error.ValidateTokenErrorProvider;
import com.mulesoft.modules.oauth2.provider.internal.token.ForbiddenSecurityException;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenAuthentication;
import com.mulesoft.modules.oauth2.provider.internal.token.UnauthorizedSecurityException;
import java.util.Arrays;
import java.util.Set;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.http.api.HttpConstants;

public class OAuth2ProviderOperations {
    @Throws(value={ValidateTokenErrorProvider.class})
    @MediaType(value="application/json")
    public Result<String, Void> validateToken(@Config OAuth2ProviderConfiguration oAuth2ProviderConfiguration, AuthenticationHandler authenticationHandler, @Expression(value=ExpressionSupport.REQUIRED) @Optional(defaultValue="#[(attributes.headers['authorization'] splitBy ' ')[1]]") @Alias(value="accessToken") String accessTokenToValidate, @Expression(value=ExpressionSupport.REQUIRED) @Optional @NullSafe @Alias(value="scopes") Set<String> scopesToValidate, @Expression(value=ExpressionSupport.REQUIRED) @Optional @NullSafe Set<String> resourceOwnerRoles) throws UnauthorizedTokenException {
        if (accessTokenToValidate == null) {
            throw new UnauthorizedTokenException(this.createErrorMessage("No access token was received", HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        }
        TokenAuthentication.Builder tokenAuthenticationBuilder = TokenAuthentication.builder();
        tokenAuthenticationBuilder.withToken(accessTokenToValidate);
        if (!resourceOwnerRoles.isEmpty()) {
            tokenAuthenticationBuilder.withResourceOwnerRoles(resourceOwnerRoles);
        }
        if (!scopesToValidate.isEmpty()) {
            tokenAuthenticationBuilder.withScopes(scopesToValidate);
        }
        TokenAuthentication tokenAuthentication = tokenAuthenticationBuilder.build();
        try {
            authenticationHandler.setAuthentication(Arrays.asList(oAuth2ProviderConfiguration.getTokenSecurityProvider().getName()), (Authentication)tokenAuthentication);
        }
        catch (SecurityException e) {
            this.handleTokenAuthenticationException((OAuth2ProviderSecurityException)((Object)e.getCause()));
        }
        catch (SecurityProviderNotFoundException | UnknownAuthenticationTypeException e) {
            throw new ModuleException((ErrorTypeDefinition)OAuth2ProviderError.OAUTH_SERVER_SECURITY, e);
        }
        return Result.builder().output((Object)this.buildJsonResponse((TokenAuthentication)authenticationHandler.getAuthentication().get())).build();
    }

    private void handleTokenAuthenticationException(OAuth2ProviderSecurityException e) throws UnauthorizedTokenException {
        if (e instanceof UnauthorizedSecurityException) {
            throw new UnauthorizedTokenException(this.createErrorMessage(e.getMessage(), HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        }
        if (e instanceof ForbiddenSecurityException) {
            throw new UnauthorizedTokenException(this.createErrorMessage(e.getMessage(), HttpConstants.HttpStatus.FORBIDDEN.getStatusCode()));
        }
    }

    private String buildJsonResponse(TokenAuthentication authentication) {
        String username;
        ResourceOwnerAuthentication resourceOwnerAuthentication;
        Token token = authentication.getTokenHolder().getAccessToken();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("expires_in", (Number)token.getExpiresIn().getSeconds());
        jsonObject.addProperty("scope", Utils.stringifyScopes(token.getScopes()));
        if (!StringUtils.isBlank((String)token.getClientId())) {
            jsonObject.addProperty("client_id", token.getClientId());
        }
        if ((resourceOwnerAuthentication = authentication.getTokenHolder().getResourceOwnerAuthentication()) != null && !StringUtils.isBlank((String)(username = resourceOwnerAuthentication.getUsername()))) {
            jsonObject.addProperty("username", username);
        }
        return jsonObject.toString();
    }

    @Throws(value={CreateClientErrorProvider.class})
    public void createClient(@Config OAuth2ProviderConfiguration oAuth2ProviderConfiguration, @Expression(value=ExpressionSupport.SUPPORTED) String clientId, @Expression(value=ExpressionSupport.SUPPORTED) @Optional(defaultValue="PUBLIC") @Alias(value="type") ClientType clientType, @Expression(value=ExpressionSupport.SUPPORTED) @Optional @Alias(value="secret") String clientSecret, @Expression(value=ExpressionSupport.SUPPORTED) @Optional String clientName, @Expression(value=ExpressionSupport.SUPPORTED) @Optional String description, @Expression(value=ExpressionSupport.SUPPORTED) @Optional String principal, @Expression(value=ExpressionSupport.REQUIRED) @Optional @NullSafe Set<String> redirectUris, @Expression(value=ExpressionSupport.REQUIRED) @Optional @NullSafe Set<Constants.RequestGrantType> authorizedGrantTypes, @Expression(value=ExpressionSupport.REQUIRED) @Optional @NullSafe Set<String> scopes, @Expression(value=ExpressionSupport.NOT_SUPPORTED) @Optional(defaultValue="false") boolean failIfPresent) throws ClientAlreadyExistsException, OAuth2ConfigurationException {
        Client client = new Client(clientId, clientSecret, clientType, redirectUris, authorizedGrantTypes, scopes);
        client.setClientName(clientName);
        client.setDescription(description);
        client.setPrincipal(principal);
        try {
            if (ClientType.CONFIDENTIAL.equals((Object)clientType) && oAuth2ProviderConfiguration.getOAuthConfiguration().getClientSecurityProvider() == null) {
                Preconditions.checkArgument((!StringUtils.isEmpty((String)clientSecret) ? 1 : 0) != 0, (String)String.format("Client secret should be specified for client: '%s' because his type is %s and no client security provider was configured", clientName, ClientType.CONFIDENTIAL.toString()));
            }
            oAuth2ProviderConfiguration.getClientManager().addClient(client, failIfPresent);
        }
        catch (IllegalArgumentException e) {
            throw new OAuth2ConfigurationException(e.getMessage());
        }
    }

    @Throws(value={DeleteClientErrorProvider.class})
    public void deleteClient(@Config OAuth2ProviderConfiguration oAuth2ProviderConfiguration, @Expression(value=ExpressionSupport.SUPPORTED) String clientId) throws NoSuchClientException {
        oAuth2ProviderConfiguration.getClientManager().removeClient(clientId);
    }

    @Throws(value={RevokeTokenErrorProvider.class})
    public void revokeToken(@Config OAuth2ProviderConfiguration oAuth2ProviderConfiguration, @Expression(value=ExpressionSupport.SUPPORTED) String token) throws InvalidTokenException {
        TokenStore tokenStore = oAuth2ProviderConfiguration.getTokenStore();
        AccessTokenStoreHolder accessToken = tokenStore.retrieveByAccessToken(token);
        if (accessToken != null) {
            tokenStore.remove(token);
            return;
        }
        AccessTokenStoreHolder refreshToken = tokenStore.retrieveByRefreshToken(token);
        if (refreshToken != null) {
            tokenStore.remove(refreshToken.getAccessToken().getAccessToken());
            return;
        }
        throw new InvalidTokenException("Token is invalid");
    }

    private Message createErrorMessage(String reasonPhrase, int statusCode) {
        return this.createErrorMessage(reasonPhrase, statusCode, null);
    }

    private Message createErrorMessage(String reasonPhrase, int statusCode, MultiMap<String, String> headers) {
        if (headers == null) {
            headers = new MultiMap();
        }
        headers.put((Object)"WWW-Authenticate", (Object)OAuth2ProviderConfiguration.WWW_AUTHENTICATE_HEADER_VALUE);
        return Message.builder().nullValue().attributesValue((Object)new HttpListenerResponseAttributes(statusCode, reasonPhrase, headers)).build();
    }
}

