/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.AbstractServePageProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

public class ServeLoginPageProcessor
extends AbstractServePageProcessor {
    public ServeLoginPageProcessor(OAuthConfiguration configuration) {
        super(configuration, configuration.getAuthorizationConfig().getLoginPage());
    }

    public void process(RequestData requestData, Client client, Set<String> effectiveScopes, HttpResponseBuilder responseBuilder) throws SecurityException {
        String clientId = this.getMandatoryParameterOrFail(requestData, "client_id");
        Constants.ResponseType responseType = this.getSupportedResponseTypeOrFail(requestData);
        String redirectUri = this.getMandatoryParameterOrFail(requestData, "redirect_uri");
        if (client == null) {
            client = this.configuration.getClientManager().getClientById(clientId);
        }
        String cssHref = "/www-static/css/login-signup.css";
        Map<String, Object> context = this.keyValuePairsToMap("CSS_HREF", "/www-static/css/login-signup.css", "PROVIDER_NAME", this.configuration.getProviderName(), "CLIENT_ID", clientId, "CLIENT_NAME", client.getClientName(), "RESPONSE_TYPE", responseType.toString(), "REDIRECT_URI", redirectUri, "SCOPE", StringUtils.join(effectiveScopes, (char)' '), "SCOPE_SET", effectiveScopes);
        responseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(this.render(context).getBytes()));
        responseBuilder.addHeader("Content-Type", MediaType.HTML.toRfcString());
    }
}

