/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.security;

import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.internal.security.ResourceOwnerSecurityProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class SpringAwareResourceOwnerSecurityProvider
extends ResourceOwnerSecurityProvider {
    private List<UserDetailsService> userDetailsServices;

    public SpringAwareResourceOwnerSecurityProvider(SecurityProvider delegate, List<UserDetailsService> userDetailsServices) {
        super(delegate);
        this.userDetailsServices = userDetailsServices;
    }

    @Override
    public ResourceOwnerAuthentication authenticate(Authentication authentication) throws SecurityException {
        ResourceOwnerAuthentication authenticatedAuth = super.authenticate(authentication);
        String authenticatedAuthUsername = this.getUsername(authenticatedAuth);
        Set<String> authenticatedAuthRoles = this.getRoles(authenticatedAuthUsername);
        return new ResourceOwnerAuthentication.Builder().withPrincipal(authenticatedAuth.getPrincipal()).withUsername(authenticatedAuthUsername).withCredentials((Object)null).withRoles(authenticatedAuthRoles).withProperties(authenticatedAuth.getProperties()).build();
    }

    private String getUsername(Authentication authentication) {
        Object user = authentication.getPrincipal();
        if (user instanceof User) {
            return ((User)user).getUsername();
        }
        return (String)user;
    }

    private Set<String> getRoles(String username) {
        HashSet<String> roles = new HashSet<String>();
        UserDetails userDetails = null;
        for (UserDetailsService userDetailsService : this.userDetailsServices) {
            try {
                userDetails = userDetailsService.loadUserByUsername(username);
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
                // empty catch block
            }
            if (userDetails == null) continue;
            for (GrantedAuthority authority : userDetails.getAuthorities()) {
                roles.add(authority.getAuthority());
            }
        }
        return roles;
    }
}

