/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api;

import static com.mulesoft.modules.oauth2.provider.api.Constants.ResponseType;
import static org.mule.runtime.api.util.Preconditions.checkArgument;
import static org.mule.runtime.core.api.util.StringUtils.isEmpty;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/**
 * Represents an authorization request. It is important to save the request
 * information for future request validation
 *
 * @since 1.0.0
 */
public class AuthorizationRequest implements Serializable {

  private static final long serialVersionUID = -7345744993248786436L;
  private final String clientId;
  private final ResponseType responseType;
  private final ResourceOwnerAuthentication resourceOwnerAuthentication;
  private final Set<String> scopes;

  private String redirectUri;

  public AuthorizationRequest(final String clientId,
                              final ResponseType responseType,
                              final String redirectUri,
                              final ResourceOwnerAuthentication resourceOwnerAuthentication) {
    checkArgument(!isEmpty(clientId), "clientId can't be empty");
    checkArgument(responseType != null, "responseType can't be null");
    checkArgument(!isEmpty(redirectUri), "redirectUri can't be empty");
    checkArgument(resourceOwnerAuthentication != null, "resourceOwnerAuthentication can't be null");

    this.clientId = clientId;
    this.responseType = responseType;
    this.resourceOwnerAuthentication = resourceOwnerAuthentication;
    this.redirectUri = redirectUri;

    scopes = new HashSet<>();
  }

  public String getClientId() {
    return clientId;
  }

  public ResponseType getResponseType() {
    return responseType;
  }

  public String getRedirectUri() {
    return redirectUri;
  }

  public ResourceOwnerAuthentication getResourceOwnerAuthentication() {
    return resourceOwnerAuthentication;
  }

  public void setRedirectUri(final String redirectUri) {
    this.redirectUri = redirectUri;
  }

  public Set<String> getScopes() {
    return scopes;
  }
}
