/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.client;


import static com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError.CLIENT_ALREADY_EXISTS;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;
import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderConfiguration;

import java.util.List;
import java.util.Set;

/**
 * {@inheritDoc}
 *
 * Exception thrown when trying to register a client with an id that is already registered.
 * </p>
 * @see com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderOperations#createClient(OAuth2ProviderConfiguration, String, ClientType, String, String, String, String, List, List, Set, boolean)
 *
 * @since 1.0.0
 */
public class ClientAlreadyExistsException extends OAuth2Exception {

  private static final long serialVersionUID = 609710968549759984L;

  public ClientAlreadyExistsException(final String msg) {
    super(msg, CLIENT_ALREADY_EXISTS);
  }

}
