/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.client;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientRegistration;

/**
 * A store that loads the information of a oauth 2.0 client.
 *
 * @since 1.0.0
 */
public interface ClientStore extends ClientRegistration {

  /**
   * Returns a client based on the provided client Id. If client Id is not valid then this method will throw an exception.
   * 
   * @param clientId The clientId
   * @return The client.
   * @throws NoSuchClientException
   * @throws OAuth2Exception
   */
  Client getClientById(final String clientId) throws NoSuchClientException;
}
